/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.BcmPricingCalculatorAsyncClient;
import software.amazon.awssdk.services.bcmpricingcalculator.internal.UserAgentUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillScenarioSummary;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosResponse;

public class ListBillScenariosPublisher
implements SdkPublisher<ListBillScenariosResponse> {
    private final BcmPricingCalculatorAsyncClient client;
    private final ListBillScenariosRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBillScenariosPublisher(BcmPricingCalculatorAsyncClient client, ListBillScenariosRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBillScenariosPublisher(BcmPricingCalculatorAsyncClient client, ListBillScenariosRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBillScenariosResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBillScenariosResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BillScenarioSummary> items() {
        Function<ListBillScenariosResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBillScenariosResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBillScenariosResponseFetcher
    implements AsyncPageFetcher<ListBillScenariosResponse> {
        private ListBillScenariosResponseFetcher() {
        }

        public boolean hasNextPage(ListBillScenariosResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBillScenariosResponse> nextPage(ListBillScenariosResponse previousPage) {
            if (previousPage == null) {
                return ListBillScenariosPublisher.this.client.listBillScenarios(ListBillScenariosPublisher.this.firstRequest);
            }
            return ListBillScenariosPublisher.this.client.listBillScenarios((ListBillScenariosRequest)((Object)ListBillScenariosPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

