/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.BcmPricingCalculatorClient;
import software.amazon.awssdk.services.bcmpricingcalculator.internal.UserAgentUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillScenarioUsageModificationItem;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsResponse;

public class ListBillScenarioUsageModificationsIterable
implements SdkIterable<ListBillScenarioUsageModificationsResponse> {
    private final BcmPricingCalculatorClient client;
    private final ListBillScenarioUsageModificationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBillScenarioUsageModificationsIterable(BcmPricingCalculatorClient client, ListBillScenarioUsageModificationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBillScenarioUsageModificationsResponseFetcher();
    }

    public Iterator<ListBillScenarioUsageModificationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BillScenarioUsageModificationItem> items() {
        Function<ListBillScenarioUsageModificationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBillScenarioUsageModificationsResponseFetcher
    implements SyncPageFetcher<ListBillScenarioUsageModificationsResponse> {
        private ListBillScenarioUsageModificationsResponseFetcher() {
        }

        public boolean hasNextPage(ListBillScenarioUsageModificationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBillScenarioUsageModificationsResponse nextPage(ListBillScenarioUsageModificationsResponse previousPage) {
            if (previousPage == null) {
                return ListBillScenarioUsageModificationsIterable.this.client.listBillScenarioUsageModifications(ListBillScenarioUsageModificationsIterable.this.firstRequest);
            }
            return ListBillScenarioUsageModificationsIterable.this.client.listBillScenarioUsageModifications((ListBillScenarioUsageModificationsRequest)((Object)ListBillScenarioUsageModificationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

