/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.BcmPricingCalculatorAsyncClient;
import software.amazon.awssdk.services.bcmpricingcalculator.internal.UserAgentUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillEstimateInputUsageModificationSummary;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsResponse;

public class ListBillEstimateInputUsageModificationsPublisher
implements SdkPublisher<ListBillEstimateInputUsageModificationsResponse> {
    private final BcmPricingCalculatorAsyncClient client;
    private final ListBillEstimateInputUsageModificationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBillEstimateInputUsageModificationsPublisher(BcmPricingCalculatorAsyncClient client, ListBillEstimateInputUsageModificationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBillEstimateInputUsageModificationsPublisher(BcmPricingCalculatorAsyncClient client, ListBillEstimateInputUsageModificationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBillEstimateInputUsageModificationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBillEstimateInputUsageModificationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BillEstimateInputUsageModificationSummary> items() {
        Function<ListBillEstimateInputUsageModificationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBillEstimateInputUsageModificationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBillEstimateInputUsageModificationsResponseFetcher
    implements AsyncPageFetcher<ListBillEstimateInputUsageModificationsResponse> {
        private ListBillEstimateInputUsageModificationsResponseFetcher() {
        }

        public boolean hasNextPage(ListBillEstimateInputUsageModificationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBillEstimateInputUsageModificationsResponse> nextPage(ListBillEstimateInputUsageModificationsResponse previousPage) {
            if (previousPage == null) {
                return ListBillEstimateInputUsageModificationsPublisher.this.client.listBillEstimateInputUsageModifications(ListBillEstimateInputUsageModificationsPublisher.this.firstRequest);
            }
            return ListBillEstimateInputUsageModificationsPublisher.this.client.listBillEstimateInputUsageModifications((ListBillEstimateInputUsageModificationsRequest)((Object)ListBillEstimateInputUsageModificationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

