/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.BcmPricingCalculatorAsyncClient;
import software.amazon.awssdk.services.bcmpricingcalculator.internal.UserAgentUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillEstimateInputCommitmentModificationSummary;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputCommitmentModificationsResponse;

public class ListBillEstimateInputCommitmentModificationsPublisher
implements SdkPublisher<ListBillEstimateInputCommitmentModificationsResponse> {
    private final BcmPricingCalculatorAsyncClient client;
    private final ListBillEstimateInputCommitmentModificationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBillEstimateInputCommitmentModificationsPublisher(BcmPricingCalculatorAsyncClient client, ListBillEstimateInputCommitmentModificationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBillEstimateInputCommitmentModificationsPublisher(BcmPricingCalculatorAsyncClient client, ListBillEstimateInputCommitmentModificationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBillEstimateInputCommitmentModificationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBillEstimateInputCommitmentModificationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BillEstimateInputCommitmentModificationSummary> items() {
        Function<ListBillEstimateInputCommitmentModificationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBillEstimateInputCommitmentModificationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBillEstimateInputCommitmentModificationsResponseFetcher
    implements AsyncPageFetcher<ListBillEstimateInputCommitmentModificationsResponse> {
        private ListBillEstimateInputCommitmentModificationsResponseFetcher() {
        }

        public boolean hasNextPage(ListBillEstimateInputCommitmentModificationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBillEstimateInputCommitmentModificationsResponse> nextPage(ListBillEstimateInputCommitmentModificationsResponse previousPage) {
            if (previousPage == null) {
                return ListBillEstimateInputCommitmentModificationsPublisher.this.client.listBillEstimateInputCommitmentModifications(ListBillEstimateInputCommitmentModificationsPublisher.this.firstRequest);
            }
            return ListBillEstimateInputCommitmentModificationsPublisher.this.client.listBillEstimateInputCommitmentModifications((ListBillEstimateInputCommitmentModificationsRequest)((Object)ListBillEstimateInputCommitmentModificationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

