/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationEntriesCopier;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateBillScenarioCommitmentModificationEntry;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BcmPricingCalculatorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCreateBillScenarioCommitmentModificationRequest
extends BcmPricingCalculatorRequest
implements ToCopyableBuilder<Builder, BatchCreateBillScenarioCommitmentModificationRequest> {
    private static final SdkField<String> BILL_SCENARIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("billScenarioId").getter(BatchCreateBillScenarioCommitmentModificationRequest.getter(BatchCreateBillScenarioCommitmentModificationRequest::billScenarioId)).setter(BatchCreateBillScenarioCommitmentModificationRequest.setter(Builder::billScenarioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billScenarioId").build()}).build();
    private static final SdkField<List<BatchCreateBillScenarioCommitmentModificationEntry>> COMMITMENT_MODIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("commitmentModifications").getter(BatchCreateBillScenarioCommitmentModificationRequest.getter(BatchCreateBillScenarioCommitmentModificationRequest::commitmentModifications)).setter(BatchCreateBillScenarioCommitmentModificationRequest.setter(Builder::commitmentModifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitmentModifications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchCreateBillScenarioCommitmentModificationEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(BatchCreateBillScenarioCommitmentModificationRequest.getter(BatchCreateBillScenarioCommitmentModificationRequest::clientToken)).setter(BatchCreateBillScenarioCommitmentModificationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILL_SCENARIO_ID_FIELD, COMMITMENT_MODIFICATIONS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchCreateBillScenarioCommitmentModificationRequest.memberNameToFieldInitializer();
    private final String billScenarioId;
    private final List<BatchCreateBillScenarioCommitmentModificationEntry> commitmentModifications;
    private final String clientToken;

    private BatchCreateBillScenarioCommitmentModificationRequest(BuilderImpl builder) {
        super(builder);
        this.billScenarioId = builder.billScenarioId;
        this.commitmentModifications = builder.commitmentModifications;
        this.clientToken = builder.clientToken;
    }

    public final String billScenarioId() {
        return this.billScenarioId;
    }

    public final boolean hasCommitmentModifications() {
        return this.commitmentModifications != null && !(this.commitmentModifications instanceof SdkAutoConstructList);
    }

    public final List<BatchCreateBillScenarioCommitmentModificationEntry> commitmentModifications() {
        return this.commitmentModifications;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.billScenarioId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommitmentModifications() ? this.commitmentModifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateBillScenarioCommitmentModificationRequest)) {
            return false;
        }
        BatchCreateBillScenarioCommitmentModificationRequest other = (BatchCreateBillScenarioCommitmentModificationRequest)((Object)obj);
        return Objects.equals(this.billScenarioId(), other.billScenarioId()) && this.hasCommitmentModifications() == other.hasCommitmentModifications() && Objects.equals(this.commitmentModifications(), other.commitmentModifications()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"BatchCreateBillScenarioCommitmentModificationRequest").add("BillScenarioId", (Object)this.billScenarioId()).add("CommitmentModifications", this.hasCommitmentModifications() ? this.commitmentModifications() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "billScenarioId": {
                return Optional.ofNullable(clazz.cast(this.billScenarioId()));
            }
            case "commitmentModifications": {
                return Optional.ofNullable(clazz.cast(this.commitmentModifications()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("billScenarioId", BILL_SCENARIO_ID_FIELD);
        map.put("commitmentModifications", COMMITMENT_MODIFICATIONS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateBillScenarioCommitmentModificationRequest, T> g) {
        return obj -> g.apply((BatchCreateBillScenarioCommitmentModificationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmPricingCalculatorRequest.BuilderImpl
    implements Builder {
        private String billScenarioId;
        private List<BatchCreateBillScenarioCommitmentModificationEntry> commitmentModifications = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateBillScenarioCommitmentModificationRequest model) {
            super(model);
            this.billScenarioId(model.billScenarioId);
            this.commitmentModifications(model.commitmentModifications);
            this.clientToken(model.clientToken);
        }

        public final String getBillScenarioId() {
            return this.billScenarioId;
        }

        public final void setBillScenarioId(String billScenarioId) {
            this.billScenarioId = billScenarioId;
        }

        @Override
        public final Builder billScenarioId(String billScenarioId) {
            this.billScenarioId = billScenarioId;
            return this;
        }

        public final List<BatchCreateBillScenarioCommitmentModificationEntry.Builder> getCommitmentModifications() {
            List<BatchCreateBillScenarioCommitmentModificationEntry.Builder> result = BatchCreateBillScenarioCommitmentModificationEntriesCopier.copyToBuilder(this.commitmentModifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommitmentModifications(Collection<BatchCreateBillScenarioCommitmentModificationEntry.BuilderImpl> commitmentModifications) {
            this.commitmentModifications = BatchCreateBillScenarioCommitmentModificationEntriesCopier.copyFromBuilder(commitmentModifications);
        }

        @Override
        public final Builder commitmentModifications(Collection<BatchCreateBillScenarioCommitmentModificationEntry> commitmentModifications) {
            this.commitmentModifications = BatchCreateBillScenarioCommitmentModificationEntriesCopier.copy(commitmentModifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commitmentModifications(BatchCreateBillScenarioCommitmentModificationEntry ... commitmentModifications) {
            this.commitmentModifications(Arrays.asList(commitmentModifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commitmentModifications(Consumer<BatchCreateBillScenarioCommitmentModificationEntry.Builder> ... commitmentModifications) {
            this.commitmentModifications(Stream.of(commitmentModifications).map(c -> (BatchCreateBillScenarioCommitmentModificationEntry)((BatchCreateBillScenarioCommitmentModificationEntry.Builder)BatchCreateBillScenarioCommitmentModificationEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchCreateBillScenarioCommitmentModificationRequest build() {
            return new BatchCreateBillScenarioCommitmentModificationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BcmPricingCalculatorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchCreateBillScenarioCommitmentModificationRequest> {
        public Builder billScenarioId(String var1);

        public Builder commitmentModifications(Collection<BatchCreateBillScenarioCommitmentModificationEntry> var1);

        public Builder commitmentModifications(BatchCreateBillScenarioCommitmentModificationEntry ... var1);

        public Builder commitmentModifications(Consumer<BatchCreateBillScenarioCommitmentModificationEntry.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

