/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.BcmPricingCalculatorClient;
import software.amazon.awssdk.services.bcmpricingcalculator.internal.UserAgentUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillScenarioSummary;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenariosResponse;

public class ListBillScenariosIterable
implements SdkIterable<ListBillScenariosResponse> {
    private final BcmPricingCalculatorClient client;
    private final ListBillScenariosRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBillScenariosIterable(BcmPricingCalculatorClient client, ListBillScenariosRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBillScenariosResponseFetcher();
    }

    public Iterator<ListBillScenariosResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BillScenarioSummary> items() {
        Function<ListBillScenariosResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBillScenariosResponseFetcher
    implements SyncPageFetcher<ListBillScenariosResponse> {
        private ListBillScenariosResponseFetcher() {
        }

        public boolean hasNextPage(ListBillScenariosResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBillScenariosResponse nextPage(ListBillScenariosResponse previousPage) {
            if (previousPage == null) {
                return ListBillScenariosIterable.this.client.listBillScenarios(ListBillScenariosIterable.this.firstRequest);
            }
            return ListBillScenariosIterable.this.client.listBillScenarios((ListBillScenariosRequest)((Object)ListBillScenariosIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

