/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CostDifference;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ServiceCostDifferenceMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BillEstimateCostSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BillEstimateCostSummary> {
    private static final SdkField<CostDifference> TOTAL_COST_DIFFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("totalCostDifference").getter(BillEstimateCostSummary.getter(BillEstimateCostSummary::totalCostDifference)).setter(BillEstimateCostSummary.setter(Builder::totalCostDifference)).constructor(CostDifference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalCostDifference").build()}).build();
    private static final SdkField<Map<String, CostDifference>> SERVICE_COST_DIFFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("serviceCostDifferences").getter(BillEstimateCostSummary.getter(BillEstimateCostSummary::serviceCostDifferences)).setter(BillEstimateCostSummary.setter(Builder::serviceCostDifferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCostDifferences").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CostDifference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_COST_DIFFERENCE_FIELD, SERVICE_COST_DIFFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("totalCostDifference", TOTAL_COST_DIFFERENCE_FIELD);
            this.put("serviceCostDifferences", SERVICE_COST_DIFFERENCES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final CostDifference totalCostDifference;
    private final Map<String, CostDifference> serviceCostDifferences;

    private BillEstimateCostSummary(BuilderImpl builder) {
        this.totalCostDifference = builder.totalCostDifference;
        this.serviceCostDifferences = builder.serviceCostDifferences;
    }

    public final CostDifference totalCostDifference() {
        return this.totalCostDifference;
    }

    public final boolean hasServiceCostDifferences() {
        return this.serviceCostDifferences != null && !(this.serviceCostDifferences instanceof SdkAutoConstructMap);
    }

    public final Map<String, CostDifference> serviceCostDifferences() {
        return this.serviceCostDifferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCostDifference());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceCostDifferences() ? this.serviceCostDifferences() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillEstimateCostSummary)) {
            return false;
        }
        BillEstimateCostSummary other = (BillEstimateCostSummary)obj;
        return Objects.equals(this.totalCostDifference(), other.totalCostDifference()) && this.hasServiceCostDifferences() == other.hasServiceCostDifferences() && Objects.equals(this.serviceCostDifferences(), other.serviceCostDifferences());
    }

    public final String toString() {
        return ToString.builder((String)"BillEstimateCostSummary").add("TotalCostDifference", (Object)this.totalCostDifference()).add("ServiceCostDifferences", this.hasServiceCostDifferences() ? this.serviceCostDifferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "totalCostDifference": {
                return Optional.ofNullable(clazz.cast(this.totalCostDifference()));
            }
            case "serviceCostDifferences": {
                return Optional.ofNullable(clazz.cast(this.serviceCostDifferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BillEstimateCostSummary, T> g) {
        return obj -> g.apply((BillEstimateCostSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CostDifference totalCostDifference;
        private Map<String, CostDifference> serviceCostDifferences = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BillEstimateCostSummary model) {
            this.totalCostDifference(model.totalCostDifference);
            this.serviceCostDifferences(model.serviceCostDifferences);
        }

        public final CostDifference.Builder getTotalCostDifference() {
            return this.totalCostDifference != null ? this.totalCostDifference.toBuilder() : null;
        }

        public final void setTotalCostDifference(CostDifference.BuilderImpl totalCostDifference) {
            this.totalCostDifference = totalCostDifference != null ? totalCostDifference.build() : null;
        }

        @Override
        public final Builder totalCostDifference(CostDifference totalCostDifference) {
            this.totalCostDifference = totalCostDifference;
            return this;
        }

        public final Map<String, CostDifference.Builder> getServiceCostDifferences() {
            Map<String, CostDifference.Builder> result = ServiceCostDifferenceMapCopier.copyToBuilder(this.serviceCostDifferences);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setServiceCostDifferences(Map<String, CostDifference.BuilderImpl> serviceCostDifferences) {
            this.serviceCostDifferences = ServiceCostDifferenceMapCopier.copyFromBuilder(serviceCostDifferences);
        }

        @Override
        public final Builder serviceCostDifferences(Map<String, CostDifference> serviceCostDifferences) {
            this.serviceCostDifferences = ServiceCostDifferenceMapCopier.copy(serviceCostDifferences);
            return this;
        }

        public BillEstimateCostSummary build() {
            return new BillEstimateCostSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BillEstimateCostSummary> {
        public Builder totalCostDifference(CostDifference var1);

        default public Builder totalCostDifference(Consumer<CostDifference.Builder> totalCostDifference) {
            return this.totalCostDifference((CostDifference)((CostDifference.Builder)CostDifference.builder().applyMutation(totalCostDifference)).build());
        }

        public Builder serviceCostDifferences(Map<String, CostDifference> var1);
    }
}

