/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BcmPricingCalculatorResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.CurrencyCode;
import software.amazon.awssdk.services.bcmpricingcalculator.model.WorkloadEstimateRateType;
import software.amazon.awssdk.services.bcmpricingcalculator.model.WorkloadEstimateStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWorkloadEstimateResponse
extends BcmPricingCalculatorResponse
implements ToCopyableBuilder<Builder, UpdateWorkloadEstimateResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateWorkloadEstimateResponse.getter(UpdateWorkloadEstimateResponse::id)).setter(UpdateWorkloadEstimateResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateWorkloadEstimateResponse.getter(UpdateWorkloadEstimateResponse::name)).setter(UpdateWorkloadEstimateResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(UpdateWorkloadEstimateResponse.getter(UpdateWorkloadEstimateResponse::createdAt)).setter(UpdateWorkloadEstimateResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expiresAt").getter(UpdateWorkloadEstimateResponse.getter(UpdateWorkloadEstimateResponse::expiresAt)).setter(UpdateWorkloadEstimateResponse.setter(Builder::expiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAt").build()}).build();
    private static final SdkField<String> RATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rateType").getter(UpdateWorkloadEstimateResponse.getter(UpdateWorkloadEstimateResponse::rateTypeAsString)).setter(UpdateWorkloadEstimateResponse.setter(Builder::rateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateType").build()}).build();
    private static final SdkField<Instant> RATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("rateTimestamp").getter(UpdateWorkloadEstimateResponse.getter(UpdateWorkloadEstimateResponse::rateTimestamp)).setter(UpdateWorkloadEstimateResponse.setter(Builder::rateTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateTimestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateWorkloadEstimateResponse.getter(UpdateWorkloadEstimateResponse::statusAsString)).setter(UpdateWorkloadEstimateResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Double> TOTAL_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("totalCost").getter(UpdateWorkloadEstimateResponse.getter(UpdateWorkloadEstimateResponse::totalCost)).setter(UpdateWorkloadEstimateResponse.setter(Builder::totalCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalCost").build()}).build();
    private static final SdkField<String> COST_CURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("costCurrency").getter(UpdateWorkloadEstimateResponse.getter(UpdateWorkloadEstimateResponse::costCurrencyAsString)).setter(UpdateWorkloadEstimateResponse.setter(Builder::costCurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costCurrency").build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureMessage").getter(UpdateWorkloadEstimateResponse.getter(UpdateWorkloadEstimateResponse::failureMessage)).setter(UpdateWorkloadEstimateResponse.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, CREATED_AT_FIELD, EXPIRES_AT_FIELD, RATE_TYPE_FIELD, RATE_TIMESTAMP_FIELD, STATUS_FIELD, TOTAL_COST_FIELD, COST_CURRENCY_FIELD, FAILURE_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("id", ID_FIELD);
            this.put("name", NAME_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("expiresAt", EXPIRES_AT_FIELD);
            this.put("rateType", RATE_TYPE_FIELD);
            this.put("rateTimestamp", RATE_TIMESTAMP_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("totalCost", TOTAL_COST_FIELD);
            this.put("costCurrency", COST_CURRENCY_FIELD);
            this.put("failureMessage", FAILURE_MESSAGE_FIELD);
        }
    });
    private final String id;
    private final String name;
    private final Instant createdAt;
    private final Instant expiresAt;
    private final String rateType;
    private final Instant rateTimestamp;
    private final String status;
    private final Double totalCost;
    private final String costCurrency;
    private final String failureMessage;

    private UpdateWorkloadEstimateResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.createdAt = builder.createdAt;
        this.expiresAt = builder.expiresAt;
        this.rateType = builder.rateType;
        this.rateTimestamp = builder.rateTimestamp;
        this.status = builder.status;
        this.totalCost = builder.totalCost;
        this.costCurrency = builder.costCurrency;
        this.failureMessage = builder.failureMessage;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant expiresAt() {
        return this.expiresAt;
    }

    public final WorkloadEstimateRateType rateType() {
        return WorkloadEstimateRateType.fromValue(this.rateType);
    }

    public final String rateTypeAsString() {
        return this.rateType;
    }

    public final Instant rateTimestamp() {
        return this.rateTimestamp;
    }

    public final WorkloadEstimateStatus status() {
        return WorkloadEstimateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Double totalCost() {
        return this.totalCost;
    }

    public final CurrencyCode costCurrency() {
        return CurrencyCode.fromValue(this.costCurrency);
    }

    public final String costCurrencyAsString() {
        return this.costCurrency;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.costCurrencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkloadEstimateResponse)) {
            return false;
        }
        UpdateWorkloadEstimateResponse other = (UpdateWorkloadEstimateResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.expiresAt(), other.expiresAt()) && Objects.equals(this.rateTypeAsString(), other.rateTypeAsString()) && Objects.equals(this.rateTimestamp(), other.rateTimestamp()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.totalCost(), other.totalCost()) && Objects.equals(this.costCurrencyAsString(), other.costCurrencyAsString()) && Objects.equals(this.failureMessage(), other.failureMessage());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWorkloadEstimateResponse").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("CreatedAt", (Object)this.createdAt()).add("ExpiresAt", (Object)this.expiresAt()).add("RateType", (Object)this.rateTypeAsString()).add("RateTimestamp", (Object)this.rateTimestamp()).add("Status", (Object)this.statusAsString()).add("TotalCost", (Object)this.totalCost()).add("CostCurrency", (Object)this.costCurrencyAsString()).add("FailureMessage", (Object)this.failureMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "expiresAt": {
                return Optional.ofNullable(clazz.cast(this.expiresAt()));
            }
            case "rateType": {
                return Optional.ofNullable(clazz.cast(this.rateTypeAsString()));
            }
            case "rateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.rateTimestamp()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "totalCost": {
                return Optional.ofNullable(clazz.cast(this.totalCost()));
            }
            case "costCurrency": {
                return Optional.ofNullable(clazz.cast(this.costCurrencyAsString()));
            }
            case "failureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkloadEstimateResponse, T> g) {
        return obj -> g.apply((UpdateWorkloadEstimateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmPricingCalculatorResponse.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private Instant createdAt;
        private Instant expiresAt;
        private String rateType;
        private Instant rateTimestamp;
        private String status;
        private Double totalCost;
        private String costCurrency;
        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkloadEstimateResponse model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.createdAt(model.createdAt);
            this.expiresAt(model.expiresAt);
            this.rateType(model.rateType);
            this.rateTimestamp(model.rateTimestamp);
            this.status(model.status);
            this.totalCost(model.totalCost);
            this.costCurrency(model.costCurrency);
            this.failureMessage(model.failureMessage);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getExpiresAt() {
            return this.expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final String getRateType() {
            return this.rateType;
        }

        public final void setRateType(String rateType) {
            this.rateType = rateType;
        }

        @Override
        public final Builder rateType(String rateType) {
            this.rateType = rateType;
            return this;
        }

        @Override
        public final Builder rateType(WorkloadEstimateRateType rateType) {
            this.rateType(rateType == null ? null : rateType.toString());
            return this;
        }

        public final Instant getRateTimestamp() {
            return this.rateTimestamp;
        }

        public final void setRateTimestamp(Instant rateTimestamp) {
            this.rateTimestamp = rateTimestamp;
        }

        @Override
        public final Builder rateTimestamp(Instant rateTimestamp) {
            this.rateTimestamp = rateTimestamp;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkloadEstimateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Double getTotalCost() {
            return this.totalCost;
        }

        public final void setTotalCost(Double totalCost) {
            this.totalCost = totalCost;
        }

        @Override
        public final Builder totalCost(Double totalCost) {
            this.totalCost = totalCost;
            return this;
        }

        public final String getCostCurrency() {
            return this.costCurrency;
        }

        public final void setCostCurrency(String costCurrency) {
            this.costCurrency = costCurrency;
        }

        @Override
        public final Builder costCurrency(String costCurrency) {
            this.costCurrency = costCurrency;
            return this;
        }

        @Override
        public final Builder costCurrency(CurrencyCode costCurrency) {
            this.costCurrency(costCurrency == null ? null : costCurrency.toString());
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        @Override
        public UpdateWorkloadEstimateResponse build() {
            return new UpdateWorkloadEstimateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BcmPricingCalculatorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWorkloadEstimateResponse> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder createdAt(Instant var1);

        public Builder expiresAt(Instant var1);

        public Builder rateType(String var1);

        public Builder rateType(WorkloadEstimateRateType var1);

        public Builder rateTimestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(WorkloadEstimateStatus var1);

        public Builder totalCost(Double var1);

        public Builder costCurrency(String var1);

        public Builder costCurrency(CurrencyCode var1);

        public Builder failureMessage(String var1);
    }
}

