/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdataexports.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bcmdataexports.model.S3OutputConfigurations;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Destination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Destination> {
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Bucket").getter(S3Destination.getter(S3Destination::s3Bucket)).setter(S3Destination.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()}).build();
    private static final SdkField<S3OutputConfigurations> S3_OUTPUT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3OutputConfigurations").getter(S3Destination.getter(S3Destination::s3OutputConfigurations)).setter(S3Destination.setter(Builder::s3OutputConfigurations)).constructor(S3OutputConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputConfigurations").build()}).build();
    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Prefix").getter(S3Destination.getter(S3Destination::s3Prefix)).setter(S3Destination.setter(Builder::s3Prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix").build()}).build();
    private static final SdkField<String> S3_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Region").getter(S3Destination.getter(S3Destination::s3Region)).setter(S3Destination.setter(Builder::s3Region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Region").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_FIELD, S3_OUTPUT_CONFIGURATIONS_FIELD, S3_PREFIX_FIELD, S3_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3Destination.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String s3Bucket;
    private final S3OutputConfigurations s3OutputConfigurations;
    private final String s3Prefix;
    private final String s3Region;

    private S3Destination(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
        this.s3OutputConfigurations = builder.s3OutputConfigurations;
        this.s3Prefix = builder.s3Prefix;
        this.s3Region = builder.s3Region;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public final S3OutputConfigurations s3OutputConfigurations() {
        return this.s3OutputConfigurations;
    }

    public final String s3Prefix() {
        return this.s3Prefix;
    }

    public final String s3Region() {
        return this.s3Region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Region());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Destination)) {
            return false;
        }
        S3Destination other = (S3Destination)obj;
        return Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3OutputConfigurations(), other.s3OutputConfigurations()) && Objects.equals(this.s3Prefix(), other.s3Prefix()) && Objects.equals(this.s3Region(), other.s3Region());
    }

    public final String toString() {
        return ToString.builder((String)"S3Destination").add("S3Bucket", (Object)this.s3Bucket()).add("S3OutputConfigurations", (Object)this.s3OutputConfigurations()).add("S3Prefix", (Object)this.s3Prefix()).add("S3Region", (Object)this.s3Region()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "S3OutputConfigurations": {
                return Optional.ofNullable(clazz.cast(this.s3OutputConfigurations()));
            }
            case "S3Prefix": {
                return Optional.ofNullable(clazz.cast(this.s3Prefix()));
            }
            case "S3Region": {
                return Optional.ofNullable(clazz.cast(this.s3Region()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("S3Bucket", S3_BUCKET_FIELD);
        map.put("S3OutputConfigurations", S3_OUTPUT_CONFIGURATIONS_FIELD);
        map.put("S3Prefix", S3_PREFIX_FIELD);
        map.put("S3Region", S3_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3Destination, T> g) {
        return obj -> g.apply((S3Destination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Bucket;
        private S3OutputConfigurations s3OutputConfigurations;
        private String s3Prefix;
        private String s3Region;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Destination model) {
            this.s3Bucket(model.s3Bucket);
            this.s3OutputConfigurations(model.s3OutputConfigurations);
            this.s3Prefix(model.s3Prefix);
            this.s3Region(model.s3Region);
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final S3OutputConfigurations.Builder getS3OutputConfigurations() {
            return this.s3OutputConfigurations != null ? this.s3OutputConfigurations.toBuilder() : null;
        }

        public final void setS3OutputConfigurations(S3OutputConfigurations.BuilderImpl s3OutputConfigurations) {
            this.s3OutputConfigurations = s3OutputConfigurations != null ? s3OutputConfigurations.build() : null;
        }

        @Override
        public final Builder s3OutputConfigurations(S3OutputConfigurations s3OutputConfigurations) {
            this.s3OutputConfigurations = s3OutputConfigurations;
            return this;
        }

        public final String getS3Prefix() {
            return this.s3Prefix;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final String getS3Region() {
            return this.s3Region;
        }

        public final void setS3Region(String s3Region) {
            this.s3Region = s3Region;
        }

        @Override
        public final Builder s3Region(String s3Region) {
            this.s3Region = s3Region;
            return this;
        }

        public S3Destination build() {
            return new S3Destination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Destination> {
        public Builder s3Bucket(String var1);

        public Builder s3OutputConfigurations(S3OutputConfigurations var1);

        default public Builder s3OutputConfigurations(Consumer<S3OutputConfigurations.Builder> s3OutputConfigurations) {
            return this.s3OutputConfigurations((S3OutputConfigurations)((S3OutputConfigurations.Builder)S3OutputConfigurations.builder().applyMutation(s3OutputConfigurations)).build());
        }

        public Builder s3Prefix(String var1);

        public Builder s3Region(String var1);
    }
}

