/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdataexports.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmdataexports.model.GenericStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TablePropertyDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TablePropertyDescription> {
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultValue").getter(TablePropertyDescription.getter(TablePropertyDescription::defaultValue)).setter(TablePropertyDescription.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(TablePropertyDescription.getter(TablePropertyDescription::description)).setter(TablePropertyDescription.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(TablePropertyDescription.getter(TablePropertyDescription::name)).setter(TablePropertyDescription.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> VALID_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValidValues").getter(TablePropertyDescription.getter(TablePropertyDescription::validValues)).setter(TablePropertyDescription.setter(Builder::validValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD, DESCRIPTION_FIELD, NAME_FIELD, VALID_VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String defaultValue;
    private final String description;
    private final String name;
    private final List<String> validValues;

    private TablePropertyDescription(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.description = builder.description;
        this.name = builder.name;
        this.validValues = builder.validValues;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasValidValues() {
        return this.validValues != null && !(this.validValues instanceof SdkAutoConstructList);
    }

    public final List<String> validValues() {
        return this.validValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidValues() ? this.validValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TablePropertyDescription)) {
            return false;
        }
        TablePropertyDescription other = (TablePropertyDescription)obj;
        return Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && this.hasValidValues() == other.hasValidValues() && Objects.equals(this.validValues(), other.validValues());
    }

    public final String toString() {
        return ToString.builder((String)"TablePropertyDescription").add("DefaultValue", (Object)this.defaultValue()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("ValidValues", this.hasValidValues() ? this.validValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ValidValues": {
                return Optional.ofNullable(clazz.cast(this.validValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TablePropertyDescription, T> g) {
        return obj -> g.apply((TablePropertyDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String defaultValue;
        private String description;
        private String name;
        private List<String> validValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TablePropertyDescription model) {
            this.defaultValue(model.defaultValue);
            this.description(model.description);
            this.name(model.name);
            this.validValues(model.validValues);
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getValidValues() {
            if (this.validValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.validValues;
        }

        public final void setValidValues(Collection<String> validValues) {
            this.validValues = GenericStringListCopier.copy(validValues);
        }

        @Override
        public final Builder validValues(Collection<String> validValues) {
            this.validValues = GenericStringListCopier.copy(validValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validValues(String ... validValues) {
            this.validValues(Arrays.asList(validValues));
            return this;
        }

        public TablePropertyDescription build() {
            return new TablePropertyDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TablePropertyDescription> {
        public Builder defaultValue(String var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder validValues(Collection<String> var1);

        public Builder validValues(String ... var1);
    }
}

