/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmdashboards.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the parameters for querying Savings Plans utilization data, including time granularity and sorting
 * preferences.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlansUtilizationQuery implements SdkPojo, Serializable,
        ToCopyableBuilder<SavingsPlansUtilizationQuery.Builder, SavingsPlansUtilizationQuery> {
    private static final SdkField<DateTimeRange> TIME_RANGE_FIELD = SdkField.<DateTimeRange> builder(MarshallingType.SDK_POJO)
            .memberName("timeRange").getter(getter(SavingsPlansUtilizationQuery::timeRange)).setter(setter(Builder::timeRange))
            .constructor(DateTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeRange").build()).build();

    private static final SdkField<String> GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("granularity").getter(getter(SavingsPlansUtilizationQuery::granularityAsString))
            .setter(setter(Builder::granularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("granularity").build()).build();

    private static final SdkField<Expression> FILTER_FIELD = SdkField.<Expression> builder(MarshallingType.SDK_POJO)
            .memberName("filter").getter(getter(SavingsPlansUtilizationQuery::filter)).setter(setter(Builder::filter))
            .constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_RANGE_FIELD,
            GRANULARITY_FIELD, FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DateTimeRange timeRange;

    private final String granularity;

    private final Expression filter;

    private SavingsPlansUtilizationQuery(BuilderImpl builder) {
        this.timeRange = builder.timeRange;
        this.granularity = builder.granularity;
        this.filter = builder.filter;
    }

    /**
     * Returns the value of the TimeRange property for this object.
     * 
     * @return The value of the TimeRange property for this object.
     */
    public final DateTimeRange timeRange() {
        return timeRange;
    }

    /**
     * <p>
     * The time granularity of the retrieved data: HOURLY, DAILY, or MONTHLY.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granularity} will
     * return {@link Granularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granularityAsString}.
     * </p>
     * 
     * @return The time granularity of the retrieved data: HOURLY, DAILY, or MONTHLY.
     * @see Granularity
     */
    public final Granularity granularity() {
        return Granularity.fromValue(granularity);
    }

    /**
     * <p>
     * The time granularity of the retrieved data: HOURLY, DAILY, or MONTHLY.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granularity} will
     * return {@link Granularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granularityAsString}.
     * </p>
     * 
     * @return The time granularity of the retrieved data: HOURLY, DAILY, or MONTHLY.
     * @see Granularity
     */
    public final String granularityAsString() {
        return granularity;
    }

    /**
     * Returns the value of the Filter property for this object.
     * 
     * @return The value of the Filter property for this object.
     */
    public final Expression filter() {
        return filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeRange());
        hashCode = 31 * hashCode + Objects.hashCode(granularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansUtilizationQuery)) {
            return false;
        }
        SavingsPlansUtilizationQuery other = (SavingsPlansUtilizationQuery) obj;
        return Objects.equals(timeRange(), other.timeRange())
                && Objects.equals(granularityAsString(), other.granularityAsString()) && Objects.equals(filter(), other.filter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SavingsPlansUtilizationQuery").add("TimeRange", timeRange())
                .add("Granularity", granularityAsString()).add("Filter", filter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timeRange":
            return Optional.ofNullable(clazz.cast(timeRange()));
        case "granularity":
            return Optional.ofNullable(clazz.cast(granularityAsString()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("timeRange", TIME_RANGE_FIELD);
        map.put("granularity", GRANULARITY_FIELD);
        map.put("filter", FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansUtilizationQuery, T> g) {
        return obj -> g.apply((SavingsPlansUtilizationQuery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlansUtilizationQuery> {
        /**
         * Sets the value of the TimeRange property for this object.
         *
         * @param timeRange
         *        The new value for the TimeRange property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRange(DateTimeRange timeRange);

        /**
         * Sets the value of the TimeRange property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DateTimeRange.Builder} avoiding the need
         * to create one manually via {@link DateTimeRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateTimeRange.Builder#build()} is called immediately and its
         * result is passed to {@link #timeRange(DateTimeRange)}.
         * 
         * @param timeRange
         *        a consumer that will call methods on {@link DateTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeRange(DateTimeRange)
         */
        default Builder timeRange(Consumer<DateTimeRange.Builder> timeRange) {
            return timeRange(DateTimeRange.builder().applyMutation(timeRange).build());
        }

        /**
         * <p>
         * The time granularity of the retrieved data: HOURLY, DAILY, or MONTHLY.
         * </p>
         * 
         * @param granularity
         *        The time granularity of the retrieved data: HOURLY, DAILY, or MONTHLY.
         * @see Granularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Granularity
         */
        Builder granularity(String granularity);

        /**
         * <p>
         * The time granularity of the retrieved data: HOURLY, DAILY, or MONTHLY.
         * </p>
         * 
         * @param granularity
         *        The time granularity of the retrieved data: HOURLY, DAILY, or MONTHLY.
         * @see Granularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Granularity
         */
        Builder granularity(Granularity granularity);

        /**
         * Sets the value of the Filter property for this object.
         *
         * @param filter
         *        The new value for the Filter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Expression filter);

        /**
         * Sets the value of the Filter property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Expression.Builder} avoiding the need to
         * create one manually via {@link Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #filter(Expression)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(Expression)
         */
        default Builder filter(Consumer<Expression.Builder> filter) {
            return filter(Expression.builder().applyMutation(filter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DateTimeRange timeRange;

        private String granularity;

        private Expression filter;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansUtilizationQuery model) {
            timeRange(model.timeRange);
            granularity(model.granularity);
            filter(model.filter);
        }

        public final DateTimeRange.Builder getTimeRange() {
            return timeRange != null ? timeRange.toBuilder() : null;
        }

        public final void setTimeRange(DateTimeRange.BuilderImpl timeRange) {
            this.timeRange = timeRange != null ? timeRange.build() : null;
        }

        @Override
        public final Builder timeRange(DateTimeRange timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        public final String getGranularity() {
            return granularity;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @Override
        public final Builder granularity(Granularity granularity) {
            this.granularity(granularity == null ? null : granularity.toString());
            return this;
        }

        public final Expression.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public SavingsPlansUtilizationQuery build() {
            return new SavingsPlansUtilizationQuery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
