/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmdashboards.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the visual representation settings for widget data, including the visualization type, styling options, and
 * display preferences for different metric types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GraphDisplayConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<GraphDisplayConfig.Builder, GraphDisplayConfig> {
    private static final SdkField<String> VISUAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("visualType").getter(getter(GraphDisplayConfig::visualTypeAsString)).setter(setter(Builder::visualType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visualType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISUAL_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String visualType;

    private GraphDisplayConfig(BuilderImpl builder) {
        this.visualType = builder.visualType;
    }

    /**
     * <p>
     * The type of visualization to use for the data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visualType} will
     * return {@link VisualType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visualTypeAsString}.
     * </p>
     * 
     * @return The type of visualization to use for the data.
     * @see VisualType
     */
    public final VisualType visualType() {
        return VisualType.fromValue(visualType);
    }

    /**
     * <p>
     * The type of visualization to use for the data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visualType} will
     * return {@link VisualType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visualTypeAsString}.
     * </p>
     * 
     * @return The type of visualization to use for the data.
     * @see VisualType
     */
    public final String visualTypeAsString() {
        return visualType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(visualTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GraphDisplayConfig)) {
            return false;
        }
        GraphDisplayConfig other = (GraphDisplayConfig) obj;
        return Objects.equals(visualTypeAsString(), other.visualTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GraphDisplayConfig").add("VisualType", visualTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "visualType":
            return Optional.ofNullable(clazz.cast(visualTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("visualType", VISUAL_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GraphDisplayConfig, T> g) {
        return obj -> g.apply((GraphDisplayConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GraphDisplayConfig> {
        /**
         * <p>
         * The type of visualization to use for the data.
         * </p>
         * 
         * @param visualType
         *        The type of visualization to use for the data.
         * @see VisualType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisualType
         */
        Builder visualType(String visualType);

        /**
         * <p>
         * The type of visualization to use for the data.
         * </p>
         * 
         * @param visualType
         *        The type of visualization to use for the data.
         * @see VisualType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisualType
         */
        Builder visualType(VisualType visualType);
    }

    static final class BuilderImpl implements Builder {
        private String visualType;

        private BuilderImpl() {
        }

        private BuilderImpl(GraphDisplayConfig model) {
            visualType(model.visualType);
        }

        public final String getVisualType() {
            return visualType;
        }

        public final void setVisualType(String visualType) {
            this.visualType = visualType;
        }

        @Override
        public final Builder visualType(String visualType) {
            this.visualType = visualType;
            return this;
        }

        @Override
        public final Builder visualType(VisualType visualType) {
            this.visualType(visualType == null ? null : visualType.toString());
            return this;
        }

        @Override
        public GraphDisplayConfig build() {
            return new GraphDisplayConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
