/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.batch.model.AttemptContainerDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttemptDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttemptDetail> {
    private static final SdkField<AttemptContainerDetail> CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AttemptDetail.getter(AttemptDetail::container)).setter(AttemptDetail.setter(Builder::container)).constructor(AttemptContainerDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("container").build()}).build();
    private static final SdkField<Long> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(AttemptDetail.getter(AttemptDetail::startedAt)).setter(AttemptDetail.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<Long> STOPPED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(AttemptDetail.getter(AttemptDetail::stoppedAt)).setter(AttemptDetail.setter(Builder::stoppedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedAt").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AttemptDetail.getter(AttemptDetail::statusReason)).setter(AttemptDetail.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_FIELD, STARTED_AT_FIELD, STOPPED_AT_FIELD, STATUS_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final AttemptContainerDetail container;
    private final Long startedAt;
    private final Long stoppedAt;
    private final String statusReason;

    private AttemptDetail(BuilderImpl builder) {
        this.container = builder.container;
        this.startedAt = builder.startedAt;
        this.stoppedAt = builder.stoppedAt;
        this.statusReason = builder.statusReason;
    }

    public AttemptContainerDetail container() {
        return this.container;
    }

    public Long startedAt() {
        return this.startedAt;
    }

    public Long stoppedAt() {
        return this.stoppedAt;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.container());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttemptDetail)) {
            return false;
        }
        AttemptDetail other = (AttemptDetail)obj;
        return Objects.equals(this.container(), other.container()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.stoppedAt(), other.stoppedAt()) && Objects.equals(this.statusReason(), other.statusReason());
    }

    public String toString() {
        return ToString.builder((String)"AttemptDetail").add("Container", (Object)this.container()).add("StartedAt", (Object)this.startedAt()).add("StoppedAt", (Object)this.stoppedAt()).add("StatusReason", (Object)this.statusReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "container": {
                return Optional.ofNullable(clazz.cast(this.container()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "stoppedAt": {
                return Optional.ofNullable(clazz.cast(this.stoppedAt()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttemptDetail, T> g) {
        return obj -> g.apply((AttemptDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AttemptContainerDetail container;
        private Long startedAt;
        private Long stoppedAt;
        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(AttemptDetail model) {
            this.container(model.container);
            this.startedAt(model.startedAt);
            this.stoppedAt(model.stoppedAt);
            this.statusReason(model.statusReason);
        }

        public final AttemptContainerDetail.Builder getContainer() {
            return this.container != null ? this.container.toBuilder() : null;
        }

        @Override
        public final Builder container(AttemptContainerDetail container) {
            this.container = container;
            return this;
        }

        public final void setContainer(AttemptContainerDetail.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        public final Long getStartedAt() {
            return this.startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        public final Long getStoppedAt() {
            return this.stoppedAt;
        }

        @Override
        public final Builder stoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
            return this;
        }

        public final void setStoppedAt(Long stoppedAt) {
            this.stoppedAt = stoppedAt;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public AttemptDetail build() {
            return new AttemptDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttemptDetail> {
        public Builder container(AttemptContainerDetail var1);

        default public Builder container(Consumer<AttemptContainerDetail.Builder> container) {
            return this.container((AttemptContainerDetail)((AttemptContainerDetail.Builder)AttemptContainerDetail.builder().applyMutation(container)).build());
        }

        public Builder startedAt(Long var1);

        public Builder stoppedAt(Long var1);

        public Builder statusReason(String var1);
    }
}

