/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Current information about a consumable resource required by a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJobsByConsumableResourceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ListJobsByConsumableResourceSummary.Builder, ListJobsByConsumableResourceSummary> {
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobArn")
            .getter(getter(ListJobsByConsumableResourceSummary::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()).build();

    private static final SdkField<String> JOB_QUEUE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobQueueArn").getter(getter(ListJobsByConsumableResourceSummary::jobQueueArn))
            .setter(setter(Builder::jobQueueArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueueArn").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(ListJobsByConsumableResourceSummary::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> JOB_DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobDefinitionArn").getter(getter(ListJobsByConsumableResourceSummary::jobDefinitionArn))
            .setter(setter(Builder::jobDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDefinitionArn").build()).build();

    private static final SdkField<String> SHARE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shareIdentifier").getter(getter(ListJobsByConsumableResourceSummary::shareIdentifier))
            .setter(setter(Builder::shareIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareIdentifier").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobStatus").getter(getter(ListJobsByConsumableResourceSummary::jobStatus))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobStatus").build()).build();

    private static final SdkField<Long> QUANTITY_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("quantity")
            .getter(getter(ListJobsByConsumableResourceSummary::quantity)).setter(setter(Builder::quantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quantity").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(ListJobsByConsumableResourceSummary::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Long> STARTED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("startedAt")
            .getter(getter(ListJobsByConsumableResourceSummary::startedAt)).setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()).build();

    private static final SdkField<Long> CREATED_AT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("createdAt")
            .getter(getter(ListJobsByConsumableResourceSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<ConsumableResourceProperties> CONSUMABLE_RESOURCE_PROPERTIES_FIELD = SdkField
            .<ConsumableResourceProperties> builder(MarshallingType.SDK_POJO)
            .memberName("consumableResourceProperties")
            .getter(getter(ListJobsByConsumableResourceSummary::consumableResourceProperties))
            .setter(setter(Builder::consumableResourceProperties))
            .constructor(ConsumableResourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumableResourceProperties")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ARN_FIELD,
            JOB_QUEUE_ARN_FIELD, JOB_NAME_FIELD, JOB_DEFINITION_ARN_FIELD, SHARE_IDENTIFIER_FIELD, JOB_STATUS_FIELD,
            QUANTITY_FIELD, STATUS_REASON_FIELD, STARTED_AT_FIELD, CREATED_AT_FIELD, CONSUMABLE_RESOURCE_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jobArn;

    private final String jobQueueArn;

    private final String jobName;

    private final String jobDefinitionArn;

    private final String shareIdentifier;

    private final String jobStatus;

    private final Long quantity;

    private final String statusReason;

    private final Long startedAt;

    private final Long createdAt;

    private final ConsumableResourceProperties consumableResourceProperties;

    private ListJobsByConsumableResourceSummary(BuilderImpl builder) {
        this.jobArn = builder.jobArn;
        this.jobQueueArn = builder.jobQueueArn;
        this.jobName = builder.jobName;
        this.jobDefinitionArn = builder.jobDefinitionArn;
        this.shareIdentifier = builder.shareIdentifier;
        this.jobStatus = builder.jobStatus;
        this.quantity = builder.quantity;
        this.statusReason = builder.statusReason;
        this.startedAt = builder.startedAt;
        this.createdAt = builder.createdAt;
        this.consumableResourceProperties = builder.consumableResourceProperties;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the job.
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job queue.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the job queue.
     */
    public final String jobQueueArn() {
        return jobQueueArn;
    }

    /**
     * <p>
     * The name of the job.
     * </p>
     * 
     * @return The name of the job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job definition.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the job definition.
     */
    public final String jobDefinitionArn() {
        return jobDefinitionArn;
    }

    /**
     * <p>
     * The fair-share scheduling policy identifier for the job.
     * </p>
     * 
     * @return The fair-share scheduling policy identifier for the job.
     */
    public final String shareIdentifier() {
        return shareIdentifier;
    }

    /**
     * <p>
     * The status of the job. Can be one of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUBMITTED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNABLE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STARTING</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the job. Can be one of:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUBMITTED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNABLE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STARTING</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>
     *         </p>
     *         </li>
     */
    public final String jobStatus() {
        return jobStatus;
    }

    /**
     * <p>
     * The total amount of the consumable resource that is available.
     * </p>
     * 
     * @return The total amount of the consumable resource that is available.
     */
    public final Long quantity() {
        return quantity;
    }

    /**
     * <p>
     * A short, human-readable string to provide more details for the current status of the job.
     * </p>
     * 
     * @return A short, human-readable string to provide more details for the current status of the job.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The Unix timestamp for when the job was started. More specifically, it's when the job transitioned from the
     * <code>STARTING</code> state to the <code>RUNNING</code> state.
     * </p>
     * 
     * @return The Unix timestamp for when the job was started. More specifically, it's when the job transitioned from
     *         the <code>STARTING</code> state to the <code>RUNNING</code> state.
     */
    public final Long startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the consumable resource was created.
     * </p>
     * 
     * @return The Unix timestamp (in milliseconds) for when the consumable resource was created.
     */
    public final Long createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Contains a list of consumable resources required by the job.
     * </p>
     * 
     * @return Contains a list of consumable resources required by the job.
     */
    public final ConsumableResourceProperties consumableResourceProperties() {
        return consumableResourceProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobQueueArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(shareIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatus());
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(consumableResourceProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsByConsumableResourceSummary)) {
            return false;
        }
        ListJobsByConsumableResourceSummary other = (ListJobsByConsumableResourceSummary) obj;
        return Objects.equals(jobArn(), other.jobArn()) && Objects.equals(jobQueueArn(), other.jobQueueArn())
                && Objects.equals(jobName(), other.jobName()) && Objects.equals(jobDefinitionArn(), other.jobDefinitionArn())
                && Objects.equals(shareIdentifier(), other.shareIdentifier()) && Objects.equals(jobStatus(), other.jobStatus())
                && Objects.equals(quantity(), other.quantity()) && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(consumableResourceProperties(), other.consumableResourceProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListJobsByConsumableResourceSummary").add("JobArn", jobArn()).add("JobQueueArn", jobQueueArn())
                .add("JobName", jobName()).add("JobDefinitionArn", jobDefinitionArn()).add("ShareIdentifier", shareIdentifier())
                .add("JobStatus", jobStatus()).add("Quantity", quantity()).add("StatusReason", statusReason())
                .add("StartedAt", startedAt()).add("CreatedAt", createdAt())
                .add("ConsumableResourceProperties", consumableResourceProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "jobQueueArn":
            return Optional.ofNullable(clazz.cast(jobQueueArn()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "jobDefinitionArn":
            return Optional.ofNullable(clazz.cast(jobDefinitionArn()));
        case "shareIdentifier":
            return Optional.ofNullable(clazz.cast(shareIdentifier()));
        case "jobStatus":
            return Optional.ofNullable(clazz.cast(jobStatus()));
        case "quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "consumableResourceProperties":
            return Optional.ofNullable(clazz.cast(consumableResourceProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobArn", JOB_ARN_FIELD);
        map.put("jobQueueArn", JOB_QUEUE_ARN_FIELD);
        map.put("jobName", JOB_NAME_FIELD);
        map.put("jobDefinitionArn", JOB_DEFINITION_ARN_FIELD);
        map.put("shareIdentifier", SHARE_IDENTIFIER_FIELD);
        map.put("jobStatus", JOB_STATUS_FIELD);
        map.put("quantity", QUANTITY_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("consumableResourceProperties", CONSUMABLE_RESOURCE_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListJobsByConsumableResourceSummary, T> g) {
        return obj -> g.apply((ListJobsByConsumableResourceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListJobsByConsumableResourceSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the job.
         * </p>
         * 
         * @param jobArn
         *        The Amazon Resource Name (ARN) of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the job queue.
         * </p>
         * 
         * @param jobQueueArn
         *        The Amazon Resource Name (ARN) of the job queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueueArn(String jobQueueArn);

        /**
         * <p>
         * The name of the job.
         * </p>
         * 
         * @param jobName
         *        The name of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the job definition.
         * </p>
         * 
         * @param jobDefinitionArn
         *        The Amazon Resource Name (ARN) of the job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionArn(String jobDefinitionArn);

        /**
         * <p>
         * The fair-share scheduling policy identifier for the job.
         * </p>
         * 
         * @param shareIdentifier
         *        The fair-share scheduling policy identifier for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareIdentifier(String shareIdentifier);

        /**
         * <p>
         * The status of the job. Can be one of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUBMITTED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNABLE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STARTING</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCEEDED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobStatus
         *        The status of the job. Can be one of:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUBMITTED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNABLE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STARTING</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The total amount of the consumable resource that is available.
         * </p>
         * 
         * @param quantity
         *        The total amount of the consumable resource that is available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Long quantity);

        /**
         * <p>
         * A short, human-readable string to provide more details for the current status of the job.
         * </p>
         * 
         * @param statusReason
         *        A short, human-readable string to provide more details for the current status of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The Unix timestamp for when the job was started. More specifically, it's when the job transitioned from the
         * <code>STARTING</code> state to the <code>RUNNING</code> state.
         * </p>
         * 
         * @param startedAt
         *        The Unix timestamp for when the job was started. More specifically, it's when the job transitioned
         *        from the <code>STARTING</code> state to the <code>RUNNING</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Long startedAt);

        /**
         * <p>
         * The Unix timestamp (in milliseconds) for when the consumable resource was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp (in milliseconds) for when the consumable resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Long createdAt);

        /**
         * <p>
         * Contains a list of consumable resources required by the job.
         * </p>
         * 
         * @param consumableResourceProperties
         *        Contains a list of consumable resources required by the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumableResourceProperties(ConsumableResourceProperties consumableResourceProperties);

        /**
         * <p>
         * Contains a list of consumable resources required by the job.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConsumableResourceProperties.Builder}
         * avoiding the need to create one manually via {@link ConsumableResourceProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConsumableResourceProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #consumableResourceProperties(ConsumableResourceProperties)}.
         * 
         * @param consumableResourceProperties
         *        a consumer that will call methods on {@link ConsumableResourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumableResourceProperties(ConsumableResourceProperties)
         */
        default Builder consumableResourceProperties(Consumer<ConsumableResourceProperties.Builder> consumableResourceProperties) {
            return consumableResourceProperties(ConsumableResourceProperties.builder()
                    .applyMutation(consumableResourceProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String jobArn;

        private String jobQueueArn;

        private String jobName;

        private String jobDefinitionArn;

        private String shareIdentifier;

        private String jobStatus;

        private Long quantity;

        private String statusReason;

        private Long startedAt;

        private Long createdAt;

        private ConsumableResourceProperties consumableResourceProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsByConsumableResourceSummary model) {
            jobArn(model.jobArn);
            jobQueueArn(model.jobQueueArn);
            jobName(model.jobName);
            jobDefinitionArn(model.jobDefinitionArn);
            shareIdentifier(model.shareIdentifier);
            jobStatus(model.jobStatus);
            quantity(model.quantity);
            statusReason(model.statusReason);
            startedAt(model.startedAt);
            createdAt(model.createdAt);
            consumableResourceProperties(model.consumableResourceProperties);
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobQueueArn() {
            return jobQueueArn;
        }

        public final void setJobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
        }

        @Override
        public final Builder jobQueueArn(String jobQueueArn) {
            this.jobQueueArn = jobQueueArn;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobDefinitionArn() {
            return jobDefinitionArn;
        }

        public final void setJobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
        }

        @Override
        public final Builder jobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
            return this;
        }

        public final String getShareIdentifier() {
            return shareIdentifier;
        }

        public final void setShareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
        }

        @Override
        public final Builder shareIdentifier(String shareIdentifier) {
            this.shareIdentifier = shareIdentifier;
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        public final Long getQuantity() {
            return quantity;
        }

        public final void setQuantity(Long quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Long quantity) {
            this.quantity = quantity;
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Long getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Long startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Long getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Long createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final ConsumableResourceProperties.Builder getConsumableResourceProperties() {
            return consumableResourceProperties != null ? consumableResourceProperties.toBuilder() : null;
        }

        public final void setConsumableResourceProperties(ConsumableResourceProperties.BuilderImpl consumableResourceProperties) {
            this.consumableResourceProperties = consumableResourceProperties != null ? consumableResourceProperties.build()
                    : null;
        }

        @Override
        public final Builder consumableResourceProperties(ConsumableResourceProperties consumableResourceProperties) {
            this.consumableResourceProperties = consumableResourceProperties;
            return this;
        }

        @Override
        public ListJobsByConsumableResourceSummary build() {
            return new ListJobsByConsumableResourceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
