/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.batch.model.BatchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubmitServiceJobResponse
extends BatchResponse
implements ToCopyableBuilder<Builder, SubmitServiceJobResponse> {
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(SubmitServiceJobResponse.getter(SubmitServiceJobResponse::jobArn)).setter(SubmitServiceJobResponse.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(SubmitServiceJobResponse.getter(SubmitServiceJobResponse::jobName)).setter(SubmitServiceJobResponse.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(SubmitServiceJobResponse.getter(SubmitServiceJobResponse::jobId)).setter(SubmitServiceJobResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ARN_FIELD, JOB_NAME_FIELD, JOB_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SubmitServiceJobResponse.memberNameToFieldInitializer();
    private final String jobArn;
    private final String jobName;
    private final String jobId;

    private SubmitServiceJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobArn = builder.jobArn;
        this.jobName = builder.jobName;
        this.jobId = builder.jobId;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String jobId() {
        return this.jobId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitServiceJobResponse)) {
            return false;
        }
        SubmitServiceJobResponse other = (SubmitServiceJobResponse)((Object)obj);
        return Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobId(), other.jobId());
    }

    public final String toString() {
        return ToString.builder((String)"SubmitServiceJobResponse").add("JobArn", (Object)this.jobArn()).add("JobName", (Object)this.jobName()).add("JobId", (Object)this.jobId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("jobArn", JOB_ARN_FIELD);
        map.put("jobName", JOB_NAME_FIELD);
        map.put("jobId", JOB_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubmitServiceJobResponse, T> g) {
        return obj -> g.apply((SubmitServiceJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchResponse.BuilderImpl
    implements Builder {
        private String jobArn;
        private String jobName;
        private String jobId;

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitServiceJobResponse model) {
            super(model);
            this.jobArn(model.jobArn);
            this.jobName(model.jobName);
            this.jobId(model.jobId);
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        @Override
        public SubmitServiceJobResponse build() {
            return new SubmitServiceJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SubmitServiceJobResponse> {
        public Builder jobArn(String var1);

        public Builder jobName(String var1);

        public Builder jobId(String var1);
    }
}

