/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServiceJobsRequest extends BatchRequest implements
        ToCopyableBuilder<ListServiceJobsRequest.Builder, ListServiceJobsRequest> {
    private static final SdkField<String> JOB_QUEUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobQueue").getter(getter(ListServiceJobsRequest::jobQueue)).setter(setter(Builder::jobQueue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueue").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobStatus").getter(getter(ListServiceJobsRequest::jobStatusAsString)).setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobStatus").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListServiceJobsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListServiceJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<KeyValuesPair>> FILTERS_FIELD = SdkField
            .<List<KeyValuesPair>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ListServiceJobsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeyValuesPair> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyValuesPair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_QUEUE_FIELD,
            JOB_STATUS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobQueue;

    private final String jobStatus;

    private final Integer maxResults;

    private final String nextToken;

    private final List<KeyValuesPair> filters;

    private ListServiceJobsRequest(BuilderImpl builder) {
        super(builder);
        this.jobQueue = builder.jobQueue;
        this.jobStatus = builder.jobStatus;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * The name or ARN of the job queue with which to list service jobs.
     * </p>
     * 
     * @return The name or ARN of the job queue with which to list service jobs.
     */
    public final String jobQueue() {
        return jobQueue;
    }

    /**
     * <p>
     * The job status with which to filter service jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link ServiceJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The job status with which to filter service jobs.
     * @see ServiceJobStatus
     */
    public final ServiceJobStatus jobStatus() {
        return ServiceJobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The job status with which to filter service jobs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link ServiceJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The job status with which to filter service jobs.
     * @see ServiceJobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The maximum number of results returned by <code>ListServiceJobs</code> in paginated output. When this parameter
     * is used, <code>ListServiceJobs</code> only returns <code>maxResults</code> results in a single page and a
     * <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending
     * another <code>ListServiceJobs</code> request with the returned <code>nextToken</code> value. This value can be
     * between 1 and 100. If this parameter isn't used, then <code>ListServiceJobs</code> returns up to 100 results and
     * a <code>nextToken</code> value if applicable.
     * </p>
     * 
     * @return The maximum number of results returned by <code>ListServiceJobs</code> in paginated output. When this
     *         parameter is used, <code>ListServiceJobs</code> only returns <code>maxResults</code> results in a single
     *         page and a <code>nextToken</code> response element. The remaining results of the initial request can be
     *         seen by sending another <code>ListServiceJobs</code> request with the returned <code>nextToken</code>
     *         value. This value can be between 1 and 100. If this parameter isn't used, then
     *         <code>ListServiceJobs</code> returns up to 100 results and a <code>nextToken</code> value if applicable.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>ListServiceJobs</code> request where
     * <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from
     * the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code>
     * when there are no more results to return.
     * </p>
     * <note>
     * <p>
     * Treat this token as an opaque identifier that's only used to retrieve the next items in a list and not for other
     * programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>ListServiceJobs</code> request
     *         where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
     *         continues from the end of the previous results that returned the <code>nextToken</code> value. This value
     *         is <code>null</code> when there are no more results to return.</p> <note>
     *         <p>
     *         Treat this token as an opaque identifier that's only used to retrieve the next items in a list and not
     *         for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters to apply to the service job list query. The filter names and values can be:
     * </p>
     * <ul>
     * <li>
     * <p>
     * name: <code>JOB_STATUS</code>
     * </p>
     * <p>
     * values: <code>SUBMITTED | PENDING | RUNNABLE | STARTING | RUNNING | SUCCEEDED | FAILED | SCHEDULED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * name: <code>JOB_NAME</code>
     * </p>
     * <p>
     * values: case-insensitive matches for the job name. If a filter value ends with an asterisk (*), it matches any
     * job name that begins with the string before the '*'.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filters to apply to the service job list query. The filter names and values can be:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         name: <code>JOB_STATUS</code>
     *         </p>
     *         <p>
     *         values: <code>SUBMITTED | PENDING | RUNNABLE | STARTING | RUNNING | SUCCEEDED | FAILED | SCHEDULED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         name: <code>JOB_NAME</code>
     *         </p>
     *         <p>
     *         values: case-insensitive matches for the job name. If a filter value ends with an asterisk (*), it
     *         matches any job name that begins with the string before the '*'.
     *         </p>
     *         </li>
     */
    public final List<KeyValuesPair> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobQueue());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceJobsRequest)) {
            return false;
        }
        ListServiceJobsRequest other = (ListServiceJobsRequest) obj;
        return Objects.equals(jobQueue(), other.jobQueue()) && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServiceJobsRequest").add("JobQueue", jobQueue()).add("JobStatus", jobStatusAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("Filters", hasFilters() ? filters() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobQueue":
            return Optional.ofNullable(clazz.cast(jobQueue()));
        case "jobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobQueue", JOB_QUEUE_FIELD);
        map.put("jobStatus", JOB_STATUS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServiceJobsRequest, T> g) {
        return obj -> g.apply((ListServiceJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListServiceJobsRequest> {
        /**
         * <p>
         * The name or ARN of the job queue with which to list service jobs.
         * </p>
         * 
         * @param jobQueue
         *        The name or ARN of the job queue with which to list service jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueue(String jobQueue);

        /**
         * <p>
         * The job status with which to filter service jobs.
         * </p>
         * 
         * @param jobStatus
         *        The job status with which to filter service jobs.
         * @see ServiceJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceJobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The job status with which to filter service jobs.
         * </p>
         * 
         * @param jobStatus
         *        The job status with which to filter service jobs.
         * @see ServiceJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceJobStatus
         */
        Builder jobStatus(ServiceJobStatus jobStatus);

        /**
         * <p>
         * The maximum number of results returned by <code>ListServiceJobs</code> in paginated output. When this
         * parameter is used, <code>ListServiceJobs</code> only returns <code>maxResults</code> results in a single page
         * and a <code>nextToken</code> response element. The remaining results of the initial request can be seen by
         * sending another <code>ListServiceJobs</code> request with the returned <code>nextToken</code> value. This
         * value can be between 1 and 100. If this parameter isn't used, then <code>ListServiceJobs</code> returns up to
         * 100 results and a <code>nextToken</code> value if applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results returned by <code>ListServiceJobs</code> in paginated output. When this
         *        parameter is used, <code>ListServiceJobs</code> only returns <code>maxResults</code> results in a
         *        single page and a <code>nextToken</code> response element. The remaining results of the initial
         *        request can be seen by sending another <code>ListServiceJobs</code> request with the returned
         *        <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn't used, then
         *        <code>ListServiceJobs</code> returns up to 100 results and a <code>nextToken</code> value if
         *        applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>ListServiceJobs</code> request
         * where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
         * continues from the end of the previous results that returned the <code>nextToken</code> value. This value is
         * <code>null</code> when there are no more results to return.
         * </p>
         * <note>
         * <p>
         * Treat this token as an opaque identifier that's only used to retrieve the next items in a list and not for
         * other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated <code>ListServiceJobs</code>
         *        request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         *        Pagination continues from the end of the previous results that returned the <code>nextToken</code>
         *        value. This value is <code>null</code> when there are no more results to return.</p> <note>
         *        <p>
         *        Treat this token as an opaque identifier that's only used to retrieve the next items in a list and not
         *        for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The filters to apply to the service job list query. The filter names and values can be:
         * </p>
         * <ul>
         * <li>
         * <p>
         * name: <code>JOB_STATUS</code>
         * </p>
         * <p>
         * values: <code>SUBMITTED | PENDING | RUNNABLE | STARTING | RUNNING | SUCCEEDED | FAILED | SCHEDULED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * name: <code>JOB_NAME</code>
         * </p>
         * <p>
         * values: case-insensitive matches for the job name. If a filter value ends with an asterisk (*), it matches
         * any job name that begins with the string before the '*'.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters to apply to the service job list query. The filter names and values can be:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        name: <code>JOB_STATUS</code>
         *        </p>
         *        <p>
         *        values:
         *        <code>SUBMITTED | PENDING | RUNNABLE | STARTING | RUNNING | SUCCEEDED | FAILED | SCHEDULED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        name: <code>JOB_NAME</code>
         *        </p>
         *        <p>
         *        values: case-insensitive matches for the job name. If a filter value ends with an asterisk (*), it
         *        matches any job name that begins with the string before the '*'.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<KeyValuesPair> filters);

        /**
         * <p>
         * The filters to apply to the service job list query. The filter names and values can be:
         * </p>
         * <ul>
         * <li>
         * <p>
         * name: <code>JOB_STATUS</code>
         * </p>
         * <p>
         * values: <code>SUBMITTED | PENDING | RUNNABLE | STARTING | RUNNING | SUCCEEDED | FAILED | SCHEDULED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * name: <code>JOB_NAME</code>
         * </p>
         * <p>
         * values: case-insensitive matches for the job name. If a filter value ends with an asterisk (*), it matches
         * any job name that begins with the string before the '*'.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        The filters to apply to the service job list query. The filter names and values can be:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        name: <code>JOB_STATUS</code>
         *        </p>
         *        <p>
         *        values:
         *        <code>SUBMITTED | PENDING | RUNNABLE | STARTING | RUNNING | SUCCEEDED | FAILED | SCHEDULED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        name: <code>JOB_NAME</code>
         *        </p>
         *        <p>
         *        values: case-insensitive matches for the job name. If a filter value ends with an asterisk (*), it
         *        matches any job name that begins with the string before the '*'.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(KeyValuesPair... filters);

        /**
         * <p>
         * The filters to apply to the service job list query. The filter names and values can be:
         * </p>
         * <ul>
         * <li>
         * <p>
         * name: <code>JOB_STATUS</code>
         * </p>
         * <p>
         * values: <code>SUBMITTED | PENDING | RUNNABLE | STARTING | RUNNING | SUCCEEDED | FAILED | SCHEDULED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * name: <code>JOB_NAME</code>
         * </p>
         * <p>
         * values: case-insensitive matches for the job name. If a filter value ends with an asterisk (*), it matches
         * any job name that begins with the string before the '*'.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.KeyValuesPair.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.batch.model.KeyValuesPair#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.KeyValuesPair.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<KeyValuesPair>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.KeyValuesPair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<KeyValuesPair>)
         */
        Builder filters(Consumer<KeyValuesPair.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private String jobQueue;

        private String jobStatus;

        private Integer maxResults;

        private String nextToken;

        private List<KeyValuesPair> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceJobsRequest model) {
            super(model);
            jobQueue(model.jobQueue);
            jobStatus(model.jobStatus);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            filters(model.filters);
        }

        public final String getJobQueue() {
            return jobQueue;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(ServiceJobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<KeyValuesPair.Builder> getFilters() {
            List<KeyValuesPair.Builder> result = ListJobsFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<KeyValuesPair.BuilderImpl> filters) {
            this.filters = ListJobsFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<KeyValuesPair> filters) {
            this.filters = ListJobsFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(KeyValuesPair... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<KeyValuesPair.Builder>... filters) {
            filters(Stream.of(filters).map(c -> KeyValuesPair.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServiceJobsRequest build() {
            return new ListServiceJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
