/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CRType {
    EC2("EC2"),
    SPOT("SPOT"),
    FARGATE("FARGATE"),
    FARGATE_SPOT("FARGATE_SPOT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CRType> VALUE_MAP;
    private final String value;

    private CRType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CRType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CRType> knownValues() {
        EnumSet<CRType> knownValues = EnumSet.allOf(CRType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CRType.class, CRType::toString);
    }
}

