/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConsumableResourceRequest extends BatchRequest implements
        ToCopyableBuilder<CreateConsumableResourceRequest.Builder, CreateConsumableResourceRequest> {
    private static final SdkField<String> CONSUMABLE_RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("consumableResourceName").getter(getter(CreateConsumableResourceRequest::consumableResourceName))
            .setter(setter(Builder::consumableResourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumableResourceName").build())
            .build();

    private static final SdkField<Long> TOTAL_QUANTITY_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalQuantity").getter(getter(CreateConsumableResourceRequest::totalQuantity))
            .setter(setter(Builder::totalQuantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalQuantity").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(CreateConsumableResourceRequest::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateConsumableResourceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONSUMABLE_RESOURCE_NAME_FIELD, TOTAL_QUANTITY_FIELD, RESOURCE_TYPE_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String consumableResourceName;

    private final Long totalQuantity;

    private final String resourceType;

    private final Map<String, String> tags;

    private CreateConsumableResourceRequest(BuilderImpl builder) {
        super(builder);
        this.consumableResourceName = builder.consumableResourceName;
        this.totalQuantity = builder.totalQuantity;
        this.resourceType = builder.resourceType;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the consumable resource. Must be unique.
     * </p>
     * 
     * @return The name of the consumable resource. Must be unique.
     */
    public final String consumableResourceName() {
        return consumableResourceName;
    }

    /**
     * <p>
     * The total amount of the consumable resource that is available. Must be non-negative.
     * </p>
     * 
     * @return The total amount of the consumable resource that is available. Must be non-negative.
     */
    public final Long totalQuantity() {
        return totalQuantity;
    }

    /**
     * <p>
     * Indicates whether the resource is available to be re-used after a job completes. Can be one of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REPLENISHABLE</code> (default)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_REPLENISHABLE</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates whether the resource is available to be re-used after a job completes. Can be one of: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REPLENISHABLE</code> (default)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_REPLENISHABLE</code>
     *         </p>
     *         </li>
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags that you apply to the consumable resource to help you categorize and organize your resources. Each tag
     * consists of a key and an optional value. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your Batch resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags that you apply to the consumable resource to help you categorize and organize your resources.
     *         Each tag consists of a key and an optional value. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your Batch
     *         resources</a>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(consumableResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(totalQuantity());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConsumableResourceRequest)) {
            return false;
        }
        CreateConsumableResourceRequest other = (CreateConsumableResourceRequest) obj;
        return Objects.equals(consumableResourceName(), other.consumableResourceName())
                && Objects.equals(totalQuantity(), other.totalQuantity()) && Objects.equals(resourceType(), other.resourceType())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConsumableResourceRequest").add("ConsumableResourceName", consumableResourceName())
                .add("TotalQuantity", totalQuantity()).add("ResourceType", resourceType()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "consumableResourceName":
            return Optional.ofNullable(clazz.cast(consumableResourceName()));
        case "totalQuantity":
            return Optional.ofNullable(clazz.cast(totalQuantity()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("consumableResourceName", CONSUMABLE_RESOURCE_NAME_FIELD);
        map.put("totalQuantity", TOTAL_QUANTITY_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConsumableResourceRequest, T> g) {
        return obj -> g.apply((CreateConsumableResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateConsumableResourceRequest> {
        /**
         * <p>
         * The name of the consumable resource. Must be unique.
         * </p>
         * 
         * @param consumableResourceName
         *        The name of the consumable resource. Must be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumableResourceName(String consumableResourceName);

        /**
         * <p>
         * The total amount of the consumable resource that is available. Must be non-negative.
         * </p>
         * 
         * @param totalQuantity
         *        The total amount of the consumable resource that is available. Must be non-negative.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalQuantity(Long totalQuantity);

        /**
         * <p>
         * Indicates whether the resource is available to be re-used after a job completes. Can be one of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REPLENISHABLE</code> (default)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_REPLENISHABLE</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        Indicates whether the resource is available to be re-used after a job completes. Can be one of: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REPLENISHABLE</code> (default)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_REPLENISHABLE</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The tags that you apply to the consumable resource to help you categorize and organize your resources. Each
         * tag consists of a key and an optional value. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your Batch resources</a>.
         * </p>
         * 
         * @param tags
         *        The tags that you apply to the consumable resource to help you categorize and organize your resources.
         *        Each tag consists of a key and an optional value. For more information, see <a
         *        href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your Batch
         *        resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private String consumableResourceName;

        private Long totalQuantity;

        private String resourceType;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConsumableResourceRequest model) {
            super(model);
            consumableResourceName(model.consumableResourceName);
            totalQuantity(model.totalQuantity);
            resourceType(model.resourceType);
            tags(model.tags);
        }

        public final String getConsumableResourceName() {
            return consumableResourceName;
        }

        public final void setConsumableResourceName(String consumableResourceName) {
            this.consumableResourceName = consumableResourceName;
        }

        @Override
        public final Builder consumableResourceName(String consumableResourceName) {
            this.consumableResourceName = consumableResourceName;
            return this;
        }

        public final Long getTotalQuantity() {
            return totalQuantity;
        }

        public final void setTotalQuantity(Long totalQuantity) {
            this.totalQuantity = totalQuantity;
        }

        @Override
        public final Builder totalQuantity(Long totalQuantity) {
            this.totalQuantity = totalQuantity;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConsumableResourceRequest build() {
            return new CreateConsumableResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
