/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EksConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EksConfiguration> {
    private static final SdkField<String> EKS_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eksClusterArn").getter(EksConfiguration.getter(EksConfiguration::eksClusterArn)).setter(EksConfiguration.setter(Builder::eksClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksClusterArn").build()}).build();
    private static final SdkField<String> KUBERNETES_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kubernetesNamespace").getter(EksConfiguration.getter(EksConfiguration::kubernetesNamespace)).setter(EksConfiguration.setter(Builder::kubernetesNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesNamespace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EKS_CLUSTER_ARN_FIELD, KUBERNETES_NAMESPACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("eksClusterArn", EKS_CLUSTER_ARN_FIELD);
            this.put("kubernetesNamespace", KUBERNETES_NAMESPACE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String eksClusterArn;
    private final String kubernetesNamespace;

    private EksConfiguration(BuilderImpl builder) {
        this.eksClusterArn = builder.eksClusterArn;
        this.kubernetesNamespace = builder.kubernetesNamespace;
    }

    public final String eksClusterArn() {
        return this.eksClusterArn;
    }

    public final String kubernetesNamespace() {
        return this.kubernetesNamespace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eksClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kubernetesNamespace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksConfiguration)) {
            return false;
        }
        EksConfiguration other = (EksConfiguration)obj;
        return Objects.equals(this.eksClusterArn(), other.eksClusterArn()) && Objects.equals(this.kubernetesNamespace(), other.kubernetesNamespace());
    }

    public final String toString() {
        return ToString.builder((String)"EksConfiguration").add("EksClusterArn", (Object)this.eksClusterArn()).add("KubernetesNamespace", (Object)this.kubernetesNamespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eksClusterArn": {
                return Optional.ofNullable(clazz.cast(this.eksClusterArn()));
            }
            case "kubernetesNamespace": {
                return Optional.ofNullable(clazz.cast(this.kubernetesNamespace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EksConfiguration, T> g) {
        return obj -> g.apply((EksConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eksClusterArn;
        private String kubernetesNamespace;

        private BuilderImpl() {
        }

        private BuilderImpl(EksConfiguration model) {
            this.eksClusterArn(model.eksClusterArn);
            this.kubernetesNamespace(model.kubernetesNamespace);
        }

        public final String getEksClusterArn() {
            return this.eksClusterArn;
        }

        public final void setEksClusterArn(String eksClusterArn) {
            this.eksClusterArn = eksClusterArn;
        }

        @Override
        public final Builder eksClusterArn(String eksClusterArn) {
            this.eksClusterArn = eksClusterArn;
            return this;
        }

        public final String getKubernetesNamespace() {
            return this.kubernetesNamespace;
        }

        public final void setKubernetesNamespace(String kubernetesNamespace) {
            this.kubernetesNamespace = kubernetesNamespace;
        }

        @Override
        public final Builder kubernetesNamespace(String kubernetesNamespace) {
            this.kubernetesNamespace = kubernetesNamespace;
            return this;
        }

        public EksConfiguration build() {
            return new EksConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EksConfiguration> {
        public Builder eksClusterArn(String var1);

        public Builder kubernetesNamespace(String var1);
    }
}

