/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.batch.model.BatchRequest;
import software.amazon.awssdk.services.batch.model.ContainerProperties;
import software.amazon.awssdk.services.batch.model.JobDefinitionType;
import software.amazon.awssdk.services.batch.model.JobTimeout;
import software.amazon.awssdk.services.batch.model.NodeProperties;
import software.amazon.awssdk.services.batch.model.ParametersMapCopier;
import software.amazon.awssdk.services.batch.model.PlatformCapability;
import software.amazon.awssdk.services.batch.model.PlatformCapabilityListCopier;
import software.amazon.awssdk.services.batch.model.RetryStrategy;
import software.amazon.awssdk.services.batch.model.TagrisTagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterJobDefinitionRequest
extends BatchRequest
implements ToCopyableBuilder<Builder, RegisterJobDefinitionRequest> {
    private static final SdkField<String> JOB_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobDefinitionName").getter(RegisterJobDefinitionRequest.getter(RegisterJobDefinitionRequest::jobDefinitionName)).setter(RegisterJobDefinitionRequest.setter(Builder::jobDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDefinitionName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(RegisterJobDefinitionRequest.getter(RegisterJobDefinitionRequest::typeAsString)).setter(RegisterJobDefinitionRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(RegisterJobDefinitionRequest.getter(RegisterJobDefinitionRequest::parameters)).setter(RegisterJobDefinitionRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ContainerProperties> CONTAINER_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("containerProperties").getter(RegisterJobDefinitionRequest.getter(RegisterJobDefinitionRequest::containerProperties)).setter(RegisterJobDefinitionRequest.setter(Builder::containerProperties)).constructor(ContainerProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerProperties").build()}).build();
    private static final SdkField<NodeProperties> NODE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("nodeProperties").getter(RegisterJobDefinitionRequest.getter(RegisterJobDefinitionRequest::nodeProperties)).setter(RegisterJobDefinitionRequest.setter(Builder::nodeProperties)).constructor(NodeProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeProperties").build()}).build();
    private static final SdkField<RetryStrategy> RETRY_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retryStrategy").getter(RegisterJobDefinitionRequest.getter(RegisterJobDefinitionRequest::retryStrategy)).setter(RegisterJobDefinitionRequest.setter(Builder::retryStrategy)).constructor(RetryStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryStrategy").build()}).build();
    private static final SdkField<Boolean> PROPAGATE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("propagateTags").getter(RegisterJobDefinitionRequest.getter(RegisterJobDefinitionRequest::propagateTags)).setter(RegisterJobDefinitionRequest.setter(Builder::propagateTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagateTags").build()}).build();
    private static final SdkField<JobTimeout> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeout").getter(RegisterJobDefinitionRequest.getter(RegisterJobDefinitionRequest::timeout)).setter(RegisterJobDefinitionRequest.setter(Builder::timeout)).constructor(JobTimeout::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeout").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(RegisterJobDefinitionRequest.getter(RegisterJobDefinitionRequest::tags)).setter(RegisterJobDefinitionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PLATFORM_CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("platformCapabilities").getter(RegisterJobDefinitionRequest.getter(RegisterJobDefinitionRequest::platformCapabilitiesAsStrings)).setter(RegisterJobDefinitionRequest.setter(Builder::platformCapabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformCapabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITION_NAME_FIELD, TYPE_FIELD, PARAMETERS_FIELD, CONTAINER_PROPERTIES_FIELD, NODE_PROPERTIES_FIELD, RETRY_STRATEGY_FIELD, PROPAGATE_TAGS_FIELD, TIMEOUT_FIELD, TAGS_FIELD, PLATFORM_CAPABILITIES_FIELD));
    private final String jobDefinitionName;
    private final String type;
    private final Map<String, String> parameters;
    private final ContainerProperties containerProperties;
    private final NodeProperties nodeProperties;
    private final RetryStrategy retryStrategy;
    private final Boolean propagateTags;
    private final JobTimeout timeout;
    private final Map<String, String> tags;
    private final List<String> platformCapabilities;

    private RegisterJobDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.jobDefinitionName = builder.jobDefinitionName;
        this.type = builder.type;
        this.parameters = builder.parameters;
        this.containerProperties = builder.containerProperties;
        this.nodeProperties = builder.nodeProperties;
        this.retryStrategy = builder.retryStrategy;
        this.propagateTags = builder.propagateTags;
        this.timeout = builder.timeout;
        this.tags = builder.tags;
        this.platformCapabilities = builder.platformCapabilities;
    }

    public final String jobDefinitionName() {
        return this.jobDefinitionName;
    }

    public final JobDefinitionType type() {
        return JobDefinitionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public final ContainerProperties containerProperties() {
        return this.containerProperties;
    }

    public final NodeProperties nodeProperties() {
        return this.nodeProperties;
    }

    public final RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public final Boolean propagateTags() {
        return this.propagateTags;
    }

    public final JobTimeout timeout() {
        return this.timeout;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final List<PlatformCapability> platformCapabilities() {
        return PlatformCapabilityListCopier.copyStringToEnum(this.platformCapabilities);
    }

    public final boolean hasPlatformCapabilities() {
        return this.platformCapabilities != null && !(this.platformCapabilities instanceof SdkAutoConstructList);
    }

    public final List<String> platformCapabilitiesAsStrings() {
        return this.platformCapabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.containerProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.propagateTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlatformCapabilities() ? this.platformCapabilitiesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterJobDefinitionRequest)) {
            return false;
        }
        RegisterJobDefinitionRequest other = (RegisterJobDefinitionRequest)((Object)obj);
        return Objects.equals(this.jobDefinitionName(), other.jobDefinitionName()) && Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.containerProperties(), other.containerProperties()) && Objects.equals(this.nodeProperties(), other.nodeProperties()) && Objects.equals(this.retryStrategy(), other.retryStrategy()) && Objects.equals(this.propagateTags(), other.propagateTags()) && Objects.equals(this.timeout(), other.timeout()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasPlatformCapabilities() == other.hasPlatformCapabilities() && Objects.equals(this.platformCapabilitiesAsStrings(), other.platformCapabilitiesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterJobDefinitionRequest").add("JobDefinitionName", (Object)this.jobDefinitionName()).add("Type", (Object)this.typeAsString()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("ContainerProperties", (Object)this.containerProperties()).add("NodeProperties", (Object)this.nodeProperties()).add("RetryStrategy", (Object)this.retryStrategy()).add("PropagateTags", (Object)this.propagateTags()).add("Timeout", (Object)this.timeout()).add("Tags", this.hasTags() ? this.tags() : null).add("PlatformCapabilities", this.hasPlatformCapabilities() ? this.platformCapabilitiesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.jobDefinitionName()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "containerProperties": {
                return Optional.ofNullable(clazz.cast(this.containerProperties()));
            }
            case "nodeProperties": {
                return Optional.ofNullable(clazz.cast(this.nodeProperties()));
            }
            case "retryStrategy": {
                return Optional.ofNullable(clazz.cast(this.retryStrategy()));
            }
            case "propagateTags": {
                return Optional.ofNullable(clazz.cast(this.propagateTags()));
            }
            case "timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "platformCapabilities": {
                return Optional.ofNullable(clazz.cast(this.platformCapabilitiesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterJobDefinitionRequest, T> g) {
        return obj -> g.apply((RegisterJobDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchRequest.BuilderImpl
    implements Builder {
        private String jobDefinitionName;
        private String type;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();
        private ContainerProperties containerProperties;
        private NodeProperties nodeProperties;
        private RetryStrategy retryStrategy;
        private Boolean propagateTags;
        private JobTimeout timeout;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<String> platformCapabilities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterJobDefinitionRequest model) {
            super(model);
            this.jobDefinitionName(model.jobDefinitionName);
            this.type(model.type);
            this.parameters(model.parameters);
            this.containerProperties(model.containerProperties);
            this.nodeProperties(model.nodeProperties);
            this.retryStrategy(model.retryStrategy);
            this.propagateTags(model.propagateTags);
            this.timeout(model.timeout);
            this.tags(model.tags);
            this.platformCapabilitiesWithStrings(model.platformCapabilities);
        }

        public final String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        @Override
        @Transient
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(JobDefinitionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        @Override
        @Transient
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final ContainerProperties.Builder getContainerProperties() {
            return this.containerProperties != null ? this.containerProperties.toBuilder() : null;
        }

        public final void setContainerProperties(ContainerProperties.BuilderImpl containerProperties) {
            this.containerProperties = containerProperties != null ? containerProperties.build() : null;
        }

        @Override
        @Transient
        public final Builder containerProperties(ContainerProperties containerProperties) {
            this.containerProperties = containerProperties;
            return this;
        }

        public final NodeProperties.Builder getNodeProperties() {
            return this.nodeProperties != null ? this.nodeProperties.toBuilder() : null;
        }

        public final void setNodeProperties(NodeProperties.BuilderImpl nodeProperties) {
            this.nodeProperties = nodeProperties != null ? nodeProperties.build() : null;
        }

        @Override
        @Transient
        public final Builder nodeProperties(NodeProperties nodeProperties) {
            this.nodeProperties = nodeProperties;
            return this;
        }

        public final RetryStrategy.Builder getRetryStrategy() {
            return this.retryStrategy != null ? this.retryStrategy.toBuilder() : null;
        }

        public final void setRetryStrategy(RetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        @Override
        @Transient
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final Boolean getPropagateTags() {
            return this.propagateTags;
        }

        public final void setPropagateTags(Boolean propagateTags) {
            this.propagateTags = propagateTags;
        }

        @Override
        @Transient
        public final Builder propagateTags(Boolean propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        public final JobTimeout.Builder getTimeout() {
            return this.timeout != null ? this.timeout.toBuilder() : null;
        }

        public final void setTimeout(JobTimeout.BuilderImpl timeout) {
            this.timeout = timeout != null ? timeout.build() : null;
        }

        @Override
        @Transient
        public final Builder timeout(JobTimeout timeout) {
            this.timeout = timeout;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagrisTagsMapCopier.copy(tags);
            return this;
        }

        public final Collection<String> getPlatformCapabilities() {
            if (this.platformCapabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.platformCapabilities;
        }

        public final void setPlatformCapabilities(Collection<String> platformCapabilities) {
            this.platformCapabilities = PlatformCapabilityListCopier.copy(platformCapabilities);
        }

        @Override
        @Transient
        public final Builder platformCapabilitiesWithStrings(Collection<String> platformCapabilities) {
            this.platformCapabilities = PlatformCapabilityListCopier.copy(platformCapabilities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder platformCapabilitiesWithStrings(String ... platformCapabilities) {
            this.platformCapabilitiesWithStrings(Arrays.asList(platformCapabilities));
            return this;
        }

        @Override
        @Transient
        public final Builder platformCapabilities(Collection<PlatformCapability> platformCapabilities) {
            this.platformCapabilities = PlatformCapabilityListCopier.copyEnumToString(platformCapabilities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder platformCapabilities(PlatformCapability ... platformCapabilities) {
            this.platformCapabilities(Arrays.asList(platformCapabilities));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterJobDefinitionRequest build() {
            return new RegisterJobDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterJobDefinitionRequest> {
        public Builder jobDefinitionName(String var1);

        public Builder type(String var1);

        public Builder type(JobDefinitionType var1);

        public Builder parameters(Map<String, String> var1);

        public Builder containerProperties(ContainerProperties var1);

        default public Builder containerProperties(Consumer<ContainerProperties.Builder> containerProperties) {
            return this.containerProperties((ContainerProperties)((ContainerProperties.Builder)ContainerProperties.builder().applyMutation(containerProperties)).build());
        }

        public Builder nodeProperties(NodeProperties var1);

        default public Builder nodeProperties(Consumer<NodeProperties.Builder> nodeProperties) {
            return this.nodeProperties((NodeProperties)((NodeProperties.Builder)NodeProperties.builder().applyMutation(nodeProperties)).build());
        }

        public Builder retryStrategy(RetryStrategy var1);

        default public Builder retryStrategy(Consumer<RetryStrategy.Builder> retryStrategy) {
            return this.retryStrategy((RetryStrategy)((RetryStrategy.Builder)RetryStrategy.builder().applyMutation(retryStrategy)).build());
        }

        public Builder propagateTags(Boolean var1);

        public Builder timeout(JobTimeout var1);

        default public Builder timeout(Consumer<JobTimeout.Builder> timeout) {
            return this.timeout((JobTimeout)((JobTimeout.Builder)JobTimeout.builder().applyMutation(timeout)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder platformCapabilitiesWithStrings(Collection<String> var1);

        public Builder platformCapabilitiesWithStrings(String ... var1);

        public Builder platformCapabilities(Collection<PlatformCapability> var1);

        public Builder platformCapabilities(PlatformCapability ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

