/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJobsRequest extends BatchRequest implements ToCopyableBuilder<ListJobsRequest.Builder, ListJobsRequest> {
    private static final SdkField<String> JOB_QUEUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListJobsRequest::jobQueue)).setter(setter(Builder::jobQueue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobQueue").build()).build();

    private static final SdkField<String> ARRAY_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListJobsRequest::arrayJobId)).setter(setter(Builder::arrayJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arrayJobId").build()).build();

    private static final SdkField<String> MULTI_NODE_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListJobsRequest::multiNodeJobId)).setter(setter(Builder::multiNodeJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiNodeJobId").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListJobsRequest::jobStatusAsString)).setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobStatus").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListJobsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_QUEUE_FIELD,
            ARRAY_JOB_ID_FIELD, MULTI_NODE_JOB_ID_FIELD, JOB_STATUS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String jobQueue;

    private final String arrayJobId;

    private final String multiNodeJobId;

    private final String jobStatus;

    private final Integer maxResults;

    private final String nextToken;

    private ListJobsRequest(BuilderImpl builder) {
        super(builder);
        this.jobQueue = builder.jobQueue;
        this.arrayJobId = builder.arrayJobId;
        this.multiNodeJobId = builder.multiNodeJobId;
        this.jobStatus = builder.jobStatus;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name or full Amazon Resource Name (ARN) of the job queue with which to list jobs.
     * </p>
     * 
     * @return The name or full Amazon Resource Name (ARN) of the job queue with which to list jobs.
     */
    public String jobQueue() {
        return jobQueue;
    }

    /**
     * <p>
     * The job ID for an array job. Specifying an array job ID with this parameter lists all child jobs from within the
     * specified array.
     * </p>
     * 
     * @return The job ID for an array job. Specifying an array job ID with this parameter lists all child jobs from
     *         within the specified array.
     */
    public String arrayJobId() {
        return arrayJobId;
    }

    /**
     * <p>
     * The job ID for a multi-node parallel job. Specifying a multi-node parallel job ID with this parameter lists all
     * nodes that are associated with the specified job.
     * </p>
     * 
     * @return The job ID for a multi-node parallel job. Specifying a multi-node parallel job ID with this parameter
     *         lists all nodes that are associated with the specified job.
     */
    public String multiNodeJobId() {
        return multiNodeJobId;
    }

    /**
     * <p>
     * The job status with which to filter jobs in the specified queue. If you do not specify a status, only
     * <code>RUNNING</code> jobs are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The job status with which to filter jobs in the specified queue. If you do not specify a status, only
     *         <code>RUNNING</code> jobs are returned.
     * @see JobStatus
     */
    public JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The job status with which to filter jobs in the specified queue. If you do not specify a status, only
     * <code>RUNNING</code> jobs are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The job status with which to filter jobs in the specified queue. If you do not specify a status, only
     *         <code>RUNNING</code> jobs are returned.
     * @see JobStatus
     */
    public String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The maximum number of results returned by <code>ListJobs</code> in paginated output. When this parameter is used,
     * <code>ListJobs</code> only returns <code>maxResults</code> results in a single page along with a
     * <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending
     * another <code>ListJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1
     * and 100. If this parameter is not used, then <code>ListJobs</code> returns up to 100 results and a
     * <code>nextToken</code> value if applicable.
     * </p>
     * 
     * @return The maximum number of results returned by <code>ListJobs</code> in paginated output. When this parameter
     *         is used, <code>ListJobs</code> only returns <code>maxResults</code> results in a single page along with a
     *         <code>nextToken</code> response element. The remaining results of the initial request can be seen by
     *         sending another <code>ListJobs</code> request with the returned <code>nextToken</code> value. This value
     *         can be between 1 and 100. If this parameter is not used, then <code>ListJobs</code> returns up to 100
     *         results and a <code>nextToken</code> value if applicable.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>ListJobs</code> request where
     * <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from
     * the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code>
     * when there are no more results to return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>ListJobs</code> request where
     *         <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
     *         continues from the end of the previous results that returned the <code>nextToken</code> value. This value
     *         is <code>null</code> when there are no more results to return.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobQueue());
        hashCode = 31 * hashCode + Objects.hashCode(arrayJobId());
        hashCode = 31 * hashCode + Objects.hashCode(multiNodeJobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsRequest)) {
            return false;
        }
        ListJobsRequest other = (ListJobsRequest) obj;
        return Objects.equals(jobQueue(), other.jobQueue()) && Objects.equals(arrayJobId(), other.arrayJobId())
                && Objects.equals(multiNodeJobId(), other.multiNodeJobId())
                && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListJobsRequest").add("JobQueue", jobQueue()).add("ArrayJobId", arrayJobId())
                .add("MultiNodeJobId", multiNodeJobId()).add("JobStatus", jobStatusAsString()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobQueue":
            return Optional.ofNullable(clazz.cast(jobQueue()));
        case "arrayJobId":
            return Optional.ofNullable(clazz.cast(arrayJobId()));
        case "multiNodeJobId":
            return Optional.ofNullable(clazz.cast(multiNodeJobId()));
        case "jobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobsRequest, T> g) {
        return obj -> g.apply((ListJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BatchRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListJobsRequest> {
        /**
         * <p>
         * The name or full Amazon Resource Name (ARN) of the job queue with which to list jobs.
         * </p>
         * 
         * @param jobQueue
         *        The name or full Amazon Resource Name (ARN) of the job queue with which to list jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobQueue(String jobQueue);

        /**
         * <p>
         * The job ID for an array job. Specifying an array job ID with this parameter lists all child jobs from within
         * the specified array.
         * </p>
         * 
         * @param arrayJobId
         *        The job ID for an array job. Specifying an array job ID with this parameter lists all child jobs from
         *        within the specified array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrayJobId(String arrayJobId);

        /**
         * <p>
         * The job ID for a multi-node parallel job. Specifying a multi-node parallel job ID with this parameter lists
         * all nodes that are associated with the specified job.
         * </p>
         * 
         * @param multiNodeJobId
         *        The job ID for a multi-node parallel job. Specifying a multi-node parallel job ID with this parameter
         *        lists all nodes that are associated with the specified job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiNodeJobId(String multiNodeJobId);

        /**
         * <p>
         * The job status with which to filter jobs in the specified queue. If you do not specify a status, only
         * <code>RUNNING</code> jobs are returned.
         * </p>
         * 
         * @param jobStatus
         *        The job status with which to filter jobs in the specified queue. If you do not specify a status, only
         *        <code>RUNNING</code> jobs are returned.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The job status with which to filter jobs in the specified queue. If you do not specify a status, only
         * <code>RUNNING</code> jobs are returned.
         * </p>
         * 
         * @param jobStatus
         *        The job status with which to filter jobs in the specified queue. If you do not specify a status, only
         *        <code>RUNNING</code> jobs are returned.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * The maximum number of results returned by <code>ListJobs</code> in paginated output. When this parameter is
         * used, <code>ListJobs</code> only returns <code>maxResults</code> results in a single page along with a
         * <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending
         * another <code>ListJobs</code> request with the returned <code>nextToken</code> value. This value can be
         * between 1 and 100. If this parameter is not used, then <code>ListJobs</code> returns up to 100 results and a
         * <code>nextToken</code> value if applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results returned by <code>ListJobs</code> in paginated output. When this
         *        parameter is used, <code>ListJobs</code> only returns <code>maxResults</code> results in a single page
         *        along with a <code>nextToken</code> response element. The remaining results of the initial request can
         *        be seen by sending another <code>ListJobs</code> request with the returned <code>nextToken</code>
         *        value. This value can be between 1 and 100. If this parameter is not used, then <code>ListJobs</code>
         *        returns up to 100 results and a <code>nextToken</code> value if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>ListJobs</code> request where
         * <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues
         * from the end of the previous results that returned the <code>nextToken</code> value. This value is
         * <code>null</code> when there are no more results to return.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated <code>ListJobs</code> request
         *        where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         *        Pagination continues from the end of the previous results that returned the <code>nextToken</code>
         *        value. This value is <code>null</code> when there are no more results to return.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BatchRequest.BuilderImpl implements Builder {
        private String jobQueue;

        private String arrayJobId;

        private String multiNodeJobId;

        private String jobStatus;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsRequest model) {
            super(model);
            jobQueue(model.jobQueue);
            arrayJobId(model.arrayJobId);
            multiNodeJobId(model.multiNodeJobId);
            jobStatus(model.jobStatus);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getJobQueue() {
            return jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        public final String getArrayJobId() {
            return arrayJobId;
        }

        @Override
        public final Builder arrayJobId(String arrayJobId) {
            this.arrayJobId = arrayJobId;
            return this;
        }

        public final void setArrayJobId(String arrayJobId) {
            this.arrayJobId = arrayJobId;
        }

        public final String getMultiNodeJobId() {
            return multiNodeJobId;
        }

        @Override
        public final Builder multiNodeJobId(String multiNodeJobId) {
            this.multiNodeJobId = multiNodeJobId;
            return this;
        }

        public final void setMultiNodeJobId(String multiNodeJobId) {
            this.multiNodeJobId = multiNodeJobId;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListJobsRequest build() {
            return new ListJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
