/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentOrder;
import software.amazon.awssdk.services.batch.model.ComputeEnvironmentOrdersCopier;
import software.amazon.awssdk.services.batch.model.JQState;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateJobQueueRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateJobQueueRequest> {
    private final String jobQueue;
    private final String state;
    private final Integer priority;
    private final List<ComputeEnvironmentOrder> computeEnvironmentOrder;

    private UpdateJobQueueRequest(BuilderImpl builder) {
        this.jobQueue = builder.jobQueue;
        this.state = builder.state;
        this.priority = builder.priority;
        this.computeEnvironmentOrder = builder.computeEnvironmentOrder;
    }

    public String jobQueue() {
        return this.jobQueue;
    }

    public JQState state() {
        return JQState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public Integer priority() {
        return this.priority;
    }

    public List<ComputeEnvironmentOrder> computeEnvironmentOrder() {
        return this.computeEnvironmentOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobQueue() == null ? 0 : this.jobQueue().hashCode());
        hashCode = 31 * hashCode + (this.stateString() == null ? 0 : this.stateString().hashCode());
        hashCode = 31 * hashCode + (this.priority() == null ? 0 : this.priority().hashCode());
        hashCode = 31 * hashCode + (this.computeEnvironmentOrder() == null ? 0 : this.computeEnvironmentOrder().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobQueueRequest)) {
            return false;
        }
        UpdateJobQueueRequest other = (UpdateJobQueueRequest)((Object)obj);
        if (other.jobQueue() == null ^ this.jobQueue() == null) {
            return false;
        }
        if (other.jobQueue() != null && !other.jobQueue().equals(this.jobQueue())) {
            return false;
        }
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        if (other.priority() == null ^ this.priority() == null) {
            return false;
        }
        if (other.priority() != null && !other.priority().equals(this.priority())) {
            return false;
        }
        if (other.computeEnvironmentOrder() == null ^ this.computeEnvironmentOrder() == null) {
            return false;
        }
        return other.computeEnvironmentOrder() == null || other.computeEnvironmentOrder().equals(this.computeEnvironmentOrder());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.jobQueue() != null) {
            sb.append("JobQueue: ").append(this.jobQueue()).append(",");
        }
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (this.priority() != null) {
            sb.append("Priority: ").append(this.priority()).append(",");
        }
        if (this.computeEnvironmentOrder() != null) {
            sb.append("ComputeEnvironmentOrder: ").append(this.computeEnvironmentOrder()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobQueue": {
                return Optional.of(clazz.cast(this.jobQueue()));
            }
            case "state": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "priority": {
                return Optional.of(clazz.cast(this.priority()));
            }
            case "computeEnvironmentOrder": {
                return Optional.of(clazz.cast(this.computeEnvironmentOrder()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String jobQueue;
        private String state;
        private Integer priority;
        private List<ComputeEnvironmentOrder> computeEnvironmentOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobQueueRequest model) {
            this.jobQueue(model.jobQueue);
            this.state(model.state);
            this.priority(model.priority);
            this.computeEnvironmentOrder(model.computeEnvironmentOrder);
        }

        public final String getJobQueue() {
            return this.jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JQState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Collection<ComputeEnvironmentOrder.Builder> getComputeEnvironmentOrder() {
            return this.computeEnvironmentOrder != null ? (Collection)this.computeEnvironmentOrder.stream().map(ComputeEnvironmentOrder::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copy(computeEnvironmentOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeEnvironmentOrder(ComputeEnvironmentOrder ... computeEnvironmentOrder) {
            this.computeEnvironmentOrder(Arrays.asList(computeEnvironmentOrder));
            return this;
        }

        public final void setComputeEnvironmentOrder(Collection<ComputeEnvironmentOrder.BuilderImpl> computeEnvironmentOrder) {
            this.computeEnvironmentOrder = ComputeEnvironmentOrdersCopier.copyFromBuilder(computeEnvironmentOrder);
        }

        public UpdateJobQueueRequest build() {
            return new UpdateJobQueueRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateJobQueueRequest> {
        public Builder jobQueue(String var1);

        public Builder state(String var1);

        public Builder state(JQState var1);

        public Builder priority(Integer var1);

        public Builder computeEnvironmentOrder(Collection<ComputeEnvironmentOrder> var1);

        public Builder computeEnvironmentOrder(ComputeEnvironmentOrder ... var1);
    }
}

