/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.model.ContainerProperties;
import software.amazon.awssdk.services.batch.model.ParametersMapCopier;
import software.amazon.awssdk.services.batch.model.RetryStrategy;
import software.amazon.awssdk.services.batch.transform.JobDefinitionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class JobDefinition
implements StructuredPojo,
ToCopyableBuilder<Builder, JobDefinition> {
    private final String jobDefinitionName;
    private final String jobDefinitionArn;
    private final Integer revision;
    private final String status;
    private final String type;
    private final Map<String, String> parameters;
    private final RetryStrategy retryStrategy;
    private final ContainerProperties containerProperties;

    private JobDefinition(BuilderImpl builder) {
        this.jobDefinitionName = builder.jobDefinitionName;
        this.jobDefinitionArn = builder.jobDefinitionArn;
        this.revision = builder.revision;
        this.status = builder.status;
        this.type = builder.type;
        this.parameters = builder.parameters;
        this.retryStrategy = builder.retryStrategy;
        this.containerProperties = builder.containerProperties;
    }

    public String jobDefinitionName() {
        return this.jobDefinitionName;
    }

    public String jobDefinitionArn() {
        return this.jobDefinitionArn;
    }

    public Integer revision() {
        return this.revision;
    }

    public String status() {
        return this.status;
    }

    public String type() {
        return this.type;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public ContainerProperties containerProperties() {
        return this.containerProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobDefinitionName() == null ? 0 : this.jobDefinitionName().hashCode());
        hashCode = 31 * hashCode + (this.jobDefinitionArn() == null ? 0 : this.jobDefinitionArn().hashCode());
        hashCode = 31 * hashCode + (this.revision() == null ? 0 : this.revision().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.retryStrategy() == null ? 0 : this.retryStrategy().hashCode());
        hashCode = 31 * hashCode + (this.containerProperties() == null ? 0 : this.containerProperties().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDefinition)) {
            return false;
        }
        JobDefinition other = (JobDefinition)obj;
        if (other.jobDefinitionName() == null ^ this.jobDefinitionName() == null) {
            return false;
        }
        if (other.jobDefinitionName() != null && !other.jobDefinitionName().equals(this.jobDefinitionName())) {
            return false;
        }
        if (other.jobDefinitionArn() == null ^ this.jobDefinitionArn() == null) {
            return false;
        }
        if (other.jobDefinitionArn() != null && !other.jobDefinitionArn().equals(this.jobDefinitionArn())) {
            return false;
        }
        if (other.revision() == null ^ this.revision() == null) {
            return false;
        }
        if (other.revision() != null && !other.revision().equals(this.revision())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.retryStrategy() == null ^ this.retryStrategy() == null) {
            return false;
        }
        if (other.retryStrategy() != null && !other.retryStrategy().equals(this.retryStrategy())) {
            return false;
        }
        if (other.containerProperties() == null ^ this.containerProperties() == null) {
            return false;
        }
        return other.containerProperties() == null || other.containerProperties().equals(this.containerProperties());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobDefinitionName() != null) {
            sb.append("JobDefinitionName: ").append(this.jobDefinitionName()).append(",");
        }
        if (this.jobDefinitionArn() != null) {
            sb.append("JobDefinitionArn: ").append(this.jobDefinitionArn()).append(",");
        }
        if (this.revision() != null) {
            sb.append("Revision: ").append(this.revision()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.retryStrategy() != null) {
            sb.append("RetryStrategy: ").append(this.retryStrategy()).append(",");
        }
        if (this.containerProperties() != null) {
            sb.append("ContainerProperties: ").append(this.containerProperties()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String jobDefinitionName;
        private String jobDefinitionArn;
        private Integer revision;
        private String status;
        private String type;
        private Map<String, String> parameters;
        private RetryStrategy retryStrategy;
        private ContainerProperties containerProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(JobDefinition model) {
            this.setJobDefinitionName(model.jobDefinitionName);
            this.setJobDefinitionArn(model.jobDefinitionArn);
            this.setRevision(model.revision);
            this.setStatus(model.status);
            this.setType(model.type);
            this.setParameters(model.parameters);
            this.setRetryStrategy(model.retryStrategy);
            this.setContainerProperties(model.containerProperties);
        }

        public final String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        public final String getJobDefinitionArn() {
            return this.jobDefinitionArn;
        }

        @Override
        public final Builder jobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
            return this;
        }

        public final void setJobDefinitionArn(String jobDefinitionArn) {
            this.jobDefinitionArn = jobDefinitionArn;
        }

        public final Integer getRevision() {
            return this.revision;
        }

        @Override
        public final Builder revision(Integer revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(Integer revision) {
            this.revision = revision;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Map<String, String> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public final RetryStrategy getRetryStrategy() {
            return this.retryStrategy;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final void setRetryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
        }

        public final ContainerProperties getContainerProperties() {
            return this.containerProperties;
        }

        @Override
        public final Builder containerProperties(ContainerProperties containerProperties) {
            this.containerProperties = containerProperties;
            return this;
        }

        public final void setContainerProperties(ContainerProperties containerProperties) {
            this.containerProperties = containerProperties;
        }

        public JobDefinition build() {
            return new JobDefinition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, JobDefinition> {
        public Builder jobDefinitionName(String var1);

        public Builder jobDefinitionArn(String var1);

        public Builder revision(Integer var1);

        public Builder status(String var1);

        public Builder type(String var1);

        public Builder parameters(Map<String, String> var1);

        public Builder retryStrategy(RetryStrategy var1);

        public Builder containerProperties(ContainerProperties var1);
    }
}

