/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.Ulimit;

@SdkInternalApi
public class UlimitMarshaller {
    private static final MarshallingInfo<Integer> HARDLIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hardLimit").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<Integer> SOFTLIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("softLimit").build();
    private static final UlimitMarshaller INSTANCE = new UlimitMarshaller();

    public static UlimitMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Ulimit ulimit, ProtocolMarshaller protocolMarshaller) {
        if (ulimit == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)ulimit.hardLimit(), HARDLIMIT_BINDING);
            protocolMarshaller.marshall((Object)ulimit.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)ulimit.softLimit(), SOFTLIMIT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

