/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.ContainerOverrides;

@SdkInternalApi
public class ContainerOverridesMarshaller {
    private static final MarshallingInfo<Integer> VCPUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vcpus").build();
    private static final MarshallingInfo<Integer> MEMORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("memory").build();
    private static final MarshallingInfo<List> COMMAND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("command").build();
    private static final MarshallingInfo<List> ENVIRONMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("environment").build();
    private static final ContainerOverridesMarshaller INSTANCE = new ContainerOverridesMarshaller();

    public static ContainerOverridesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ContainerOverrides containerOverrides, ProtocolMarshaller protocolMarshaller) {
        if (containerOverrides == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)containerOverrides.vcpus(), VCPUS_BINDING);
            protocolMarshaller.marshall((Object)containerOverrides.memory(), MEMORY_BINDING);
            protocolMarshaller.marshall(containerOverrides.command(), COMMAND_BINDING);
            protocolMarshaller.marshall(containerOverrides.environment(), ENVIRONMENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

