/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.batch.model.ContainerProperties;
import software.amazon.awssdk.services.batch.model.JobDefinitionType;
import software.amazon.awssdk.services.batch.model.ParametersMapCopier;
import software.amazon.awssdk.services.batch.model.RetryStrategy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RegisterJobDefinitionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RegisterJobDefinitionRequest> {
    private final String jobDefinitionName;
    private final String type;
    private final Map<String, String> parameters;
    private final ContainerProperties containerProperties;
    private final RetryStrategy retryStrategy;

    private RegisterJobDefinitionRequest(BuilderImpl builder) {
        this.jobDefinitionName = builder.jobDefinitionName;
        this.type = builder.type;
        this.parameters = builder.parameters;
        this.containerProperties = builder.containerProperties;
        this.retryStrategy = builder.retryStrategy;
    }

    public String jobDefinitionName() {
        return this.jobDefinitionName;
    }

    public String type() {
        return this.type;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public ContainerProperties containerProperties() {
        return this.containerProperties;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobDefinitionName() == null ? 0 : this.jobDefinitionName().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.containerProperties() == null ? 0 : this.containerProperties().hashCode());
        hashCode = 31 * hashCode + (this.retryStrategy() == null ? 0 : this.retryStrategy().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterJobDefinitionRequest)) {
            return false;
        }
        RegisterJobDefinitionRequest other = (RegisterJobDefinitionRequest)((Object)obj);
        if (other.jobDefinitionName() == null ^ this.jobDefinitionName() == null) {
            return false;
        }
        if (other.jobDefinitionName() != null && !other.jobDefinitionName().equals(this.jobDefinitionName())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.containerProperties() == null ^ this.containerProperties() == null) {
            return false;
        }
        if (other.containerProperties() != null && !other.containerProperties().equals(this.containerProperties())) {
            return false;
        }
        if (other.retryStrategy() == null ^ this.retryStrategy() == null) {
            return false;
        }
        return other.retryStrategy() == null || other.retryStrategy().equals(this.retryStrategy());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobDefinitionName() != null) {
            sb.append("JobDefinitionName: ").append(this.jobDefinitionName()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.containerProperties() != null) {
            sb.append("ContainerProperties: ").append(this.containerProperties()).append(",");
        }
        if (this.retryStrategy() != null) {
            sb.append("RetryStrategy: ").append(this.retryStrategy()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String jobDefinitionName;
        private String type;
        private Map<String, String> parameters;
        private ContainerProperties containerProperties;
        private RetryStrategy retryStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterJobDefinitionRequest model) {
            this.setJobDefinitionName(model.jobDefinitionName);
            this.setType(model.type);
            this.setParameters(model.parameters);
            this.setContainerProperties(model.containerProperties);
            this.setRetryStrategy(model.retryStrategy);
        }

        public final String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(JobDefinitionType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Map<String, String> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public final ContainerProperties getContainerProperties() {
            return this.containerProperties;
        }

        @Override
        public final Builder containerProperties(ContainerProperties containerProperties) {
            this.containerProperties = containerProperties;
            return this;
        }

        public final void setContainerProperties(ContainerProperties containerProperties) {
            this.containerProperties = containerProperties;
        }

        public final RetryStrategy getRetryStrategy() {
            return this.retryStrategy;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final void setRetryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
        }

        public RegisterJobDefinitionRequest build() {
            return new RegisterJobDefinitionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RegisterJobDefinitionRequest> {
        public Builder jobDefinitionName(String var1);

        public Builder type(String var1);

        public Builder type(JobDefinitionType var1);

        public Builder parameters(Map<String, String> var1);

        public Builder containerProperties(ContainerProperties var1);

        public Builder retryStrategy(RetryStrategy var1);
    }
}

