/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.batch.model.JobSummary;
import software.amazon.awssdk.services.batch.model.JobSummaryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListJobsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListJobsResponse> {
    private final List<JobSummary> jobSummaryList;
    private final String nextToken;

    private ListJobsResponse(BuilderImpl builder) {
        this.jobSummaryList = builder.jobSummaryList;
        this.nextToken = builder.nextToken;
    }

    public List<JobSummary> jobSummaryList() {
        return this.jobSummaryList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobSummaryList() == null ? 0 : this.jobSummaryList().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsResponse)) {
            return false;
        }
        ListJobsResponse other = (ListJobsResponse)((Object)obj);
        if (other.jobSummaryList() == null ^ this.jobSummaryList() == null) {
            return false;
        }
        if (other.jobSummaryList() != null && !other.jobSummaryList().equals(this.jobSummaryList())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobSummaryList() != null) {
            sb.append("JobSummaryList: ").append(this.jobSummaryList()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<JobSummary> jobSummaryList;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsResponse model) {
            this.setJobSummaryList(model.jobSummaryList);
            this.setNextToken(model.nextToken);
        }

        public final Collection<JobSummary> getJobSummaryList() {
            return this.jobSummaryList;
        }

        @Override
        public final Builder jobSummaryList(Collection<JobSummary> jobSummaryList) {
            this.jobSummaryList = JobSummaryListCopier.copy(jobSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobSummaryList(JobSummary ... jobSummaryList) {
            this.jobSummaryList(Arrays.asList(jobSummaryList));
            return this;
        }

        public final void setJobSummaryList(Collection<JobSummary> jobSummaryList) {
            this.jobSummaryList = JobSummaryListCopier.copy(jobSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListJobsResponse build() {
            return new ListJobsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListJobsResponse> {
        public Builder jobSummaryList(Collection<JobSummary> var1);

        public Builder jobSummaryList(JobSummary ... var1);

        public Builder nextToken(String var1);
    }
}

