/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.Host;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HostMarshaller {
    private static final MarshallingInfo<String> SOURCEPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourcePath").isBinary(false).build();
    private static final HostMarshaller INSTANCE = new HostMarshaller();

    private HostMarshaller() {
    }

    public static HostMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Host host, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)host, (String)"host");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)host.sourcePath(), SOURCEPATH_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

