/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.model.SubmitJobRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SubmitJobRequestModelMarshaller {
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobName").isBinary(false).build();
    private static final MarshallingInfo<String> JOBQUEUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobQueue").isBinary(false).build();
    private static final MarshallingInfo<List> DEPENDSON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dependsOn").isBinary(false).build();
    private static final MarshallingInfo<String> JOBDEFINITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobDefinition").isBinary(false).build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parameters").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CONTAINEROVERRIDES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containerOverrides").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RETRYSTRATEGY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("retryStrategy").isBinary(false).build();
    private static final SubmitJobRequestModelMarshaller INSTANCE = new SubmitJobRequestModelMarshaller();

    private SubmitJobRequestModelMarshaller() {
    }

    public static SubmitJobRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SubmitJobRequest submitJobRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)submitJobRequest), (String)"submitJobRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)submitJobRequest.jobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall((Object)submitJobRequest.jobQueue(), JOBQUEUE_BINDING);
            protocolMarshaller.marshall(submitJobRequest.dependsOn(), DEPENDSON_BINDING);
            protocolMarshaller.marshall((Object)submitJobRequest.jobDefinition(), JOBDEFINITION_BINDING);
            protocolMarshaller.marshall(submitJobRequest.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)submitJobRequest.containerOverrides(), CONTAINEROVERRIDES_BINDING);
            protocolMarshaller.marshall((Object)submitJobRequest.retryStrategy(), RETRYSTRATEGY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

