/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.batch.model.BatchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelJobRequest
extends BatchRequest
implements ToCopyableBuilder<Builder, CancelJobRequest> {
    private final String jobId;
    private final String reason;

    private CancelJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.reason = builder.reason;
    }

    public String jobId() {
        return this.jobId;
    }

    public String reason() {
        return this.reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelJobRequest)) {
            return false;
        }
        CancelJobRequest other = (CancelJobRequest)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.reason(), other.reason());
    }

    public String toString() {
        return ToString.builder((String)"CancelJobRequest").add("JobId", (Object)this.jobId()).add("Reason", (Object)this.reason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends BatchRequest.BuilderImpl
    implements Builder {
        private String jobId;
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelJobRequest model) {
            super(model);
            this.jobId(model.jobId);
            this.reason(model.reason);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelJobRequest build() {
            return new CancelJobRequest(this);
        }
    }

    public static interface Builder
    extends BatchRequest.Builder,
    CopyableBuilder<Builder, CancelJobRequest> {
        public Builder jobId(String var1);

        public Builder reason(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

