/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.batch.model.BatchRequest;
import software.amazon.awssdk.services.batch.model.ContainerOverrides;
import software.amazon.awssdk.services.batch.model.JobDependency;
import software.amazon.awssdk.services.batch.model.JobDependencyListCopier;
import software.amazon.awssdk.services.batch.model.ParametersMapCopier;
import software.amazon.awssdk.services.batch.model.RetryStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SubmitJobRequest
extends BatchRequest
implements ToCopyableBuilder<Builder, SubmitJobRequest> {
    private final String jobName;
    private final String jobQueue;
    private final List<JobDependency> dependsOn;
    private final String jobDefinition;
    private final Map<String, String> parameters;
    private final ContainerOverrides containerOverrides;
    private final RetryStrategy retryStrategy;

    private SubmitJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.jobQueue = builder.jobQueue;
        this.dependsOn = builder.dependsOn;
        this.jobDefinition = builder.jobDefinition;
        this.parameters = builder.parameters;
        this.containerOverrides = builder.containerOverrides;
        this.retryStrategy = builder.retryStrategy;
    }

    public String jobName() {
        return this.jobName;
    }

    public String jobQueue() {
        return this.jobQueue;
    }

    public List<JobDependency> dependsOn() {
        return this.dependsOn;
    }

    public String jobDefinition() {
        return this.jobDefinition;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public ContainerOverrides containerOverrides() {
        return this.containerOverrides;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobQueue());
        hashCode = 31 * hashCode + Objects.hashCode(this.dependsOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryStrategy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitJobRequest)) {
            return false;
        }
        SubmitJobRequest other = (SubmitJobRequest)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobQueue(), other.jobQueue()) && Objects.equals(this.dependsOn(), other.dependsOn()) && Objects.equals(this.jobDefinition(), other.jobDefinition()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.containerOverrides(), other.containerOverrides()) && Objects.equals(this.retryStrategy(), other.retryStrategy());
    }

    public String toString() {
        return ToString.builder((String)"SubmitJobRequest").add("JobName", (Object)this.jobName()).add("JobQueue", (Object)this.jobQueue()).add("DependsOn", this.dependsOn()).add("JobDefinition", (Object)this.jobDefinition()).add("Parameters", this.parameters()).add("ContainerOverrides", (Object)this.containerOverrides()).add("RetryStrategy", (Object)this.retryStrategy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobName": {
                return Optional.of(clazz.cast(this.jobName()));
            }
            case "jobQueue": {
                return Optional.of(clazz.cast(this.jobQueue()));
            }
            case "dependsOn": {
                return Optional.of(clazz.cast(this.dependsOn()));
            }
            case "jobDefinition": {
                return Optional.of(clazz.cast(this.jobDefinition()));
            }
            case "parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "containerOverrides": {
                return Optional.of(clazz.cast(this.containerOverrides()));
            }
            case "retryStrategy": {
                return Optional.of(clazz.cast(this.retryStrategy()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends BatchRequest.BuilderImpl
    implements Builder {
        private String jobName;
        private String jobQueue;
        private List<JobDependency> dependsOn;
        private String jobDefinition;
        private Map<String, String> parameters;
        private ContainerOverrides containerOverrides;
        private RetryStrategy retryStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitJobRequest model) {
            super(model);
            this.jobName(model.jobName);
            this.jobQueue(model.jobQueue);
            this.dependsOn(model.dependsOn);
            this.jobDefinition(model.jobDefinition);
            this.parameters(model.parameters);
            this.containerOverrides(model.containerOverrides);
            this.retryStrategy(model.retryStrategy);
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getJobQueue() {
            return this.jobQueue;
        }

        @Override
        public final Builder jobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
            return this;
        }

        public final void setJobQueue(String jobQueue) {
            this.jobQueue = jobQueue;
        }

        public final Collection<JobDependency.Builder> getDependsOn() {
            return this.dependsOn != null ? (Collection)this.dependsOn.stream().map(JobDependency::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dependsOn(Collection<JobDependency> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copy(dependsOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(JobDependency ... dependsOn) {
            this.dependsOn(Arrays.asList(dependsOn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(Consumer<JobDependency.Builder> ... dependsOn) {
            this.dependsOn(Stream.of(dependsOn).map(c -> (JobDependency)((JobDependency.Builder)JobDependency.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDependsOn(Collection<JobDependency.BuilderImpl> dependsOn) {
            this.dependsOn = JobDependencyListCopier.copyFromBuilder(dependsOn);
        }

        public final String getJobDefinition() {
            return this.jobDefinition;
        }

        @Override
        public final Builder jobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
            return this;
        }

        public final void setJobDefinition(String jobDefinition) {
            this.jobDefinition = jobDefinition;
        }

        public final Map<String, String> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        public final ContainerOverrides.Builder getContainerOverrides() {
            return this.containerOverrides != null ? this.containerOverrides.toBuilder() : null;
        }

        @Override
        public final Builder containerOverrides(ContainerOverrides containerOverrides) {
            this.containerOverrides = containerOverrides;
            return this;
        }

        public final void setContainerOverrides(ContainerOverrides.BuilderImpl containerOverrides) {
            this.containerOverrides = containerOverrides != null ? containerOverrides.build() : null;
        }

        public final RetryStrategy.Builder getRetryStrategy() {
            return this.retryStrategy != null ? this.retryStrategy.toBuilder() : null;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final void setRetryStrategy(RetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SubmitJobRequest build() {
            return new SubmitJobRequest(this);
        }
    }

    public static interface Builder
    extends BatchRequest.Builder,
    CopyableBuilder<Builder, SubmitJobRequest> {
        public Builder jobName(String var1);

        public Builder jobQueue(String var1);

        public Builder dependsOn(Collection<JobDependency> var1);

        public Builder dependsOn(JobDependency ... var1);

        public Builder dependsOn(Consumer<JobDependency.Builder> ... var1);

        public Builder jobDefinition(String var1);

        public Builder parameters(Map<String, String> var1);

        public Builder containerOverrides(ContainerOverrides var1);

        default public Builder containerOverrides(Consumer<ContainerOverrides.Builder> containerOverrides) {
            return this.containerOverrides((ContainerOverrides)((ContainerOverrides.Builder)ContainerOverrides.builder().apply(containerOverrides)).build());
        }

        public Builder retryStrategy(RetryStrategy var1);

        default public Builder retryStrategy(Consumer<RetryStrategy.Builder> retryStrategy) {
            return this.retryStrategy((RetryStrategy)((RetryStrategy.Builder)RetryStrategy.builder().apply(retryStrategy)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

