/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.UlimitMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Ulimit
implements StructuredPojo,
ToCopyableBuilder<Builder, Ulimit> {
    private final Integer hardLimit;
    private final String name;
    private final Integer softLimit;

    private Ulimit(BuilderImpl builder) {
        this.hardLimit = builder.hardLimit;
        this.name = builder.name;
        this.softLimit = builder.softLimit;
    }

    public Integer hardLimit() {
        return this.hardLimit;
    }

    public String name() {
        return this.name;
    }

    public Integer softLimit() {
        return this.softLimit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hardLimit() == null ? 0 : this.hardLimit().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.softLimit() == null ? 0 : this.softLimit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ulimit)) {
            return false;
        }
        Ulimit other = (Ulimit)obj;
        if (other.hardLimit() == null ^ this.hardLimit() == null) {
            return false;
        }
        if (other.hardLimit() != null && !other.hardLimit().equals(this.hardLimit())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.softLimit() == null ^ this.softLimit() == null) {
            return false;
        }
        return other.softLimit() == null || other.softLimit().equals(this.softLimit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hardLimit() != null) {
            sb.append("HardLimit: ").append(this.hardLimit()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.softLimit() != null) {
            sb.append("SoftLimit: ").append(this.softLimit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UlimitMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer hardLimit;
        private String name;
        private Integer softLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(Ulimit model) {
            this.setHardLimit(model.hardLimit);
            this.setName(model.name);
            this.setSoftLimit(model.softLimit);
        }

        public final Integer getHardLimit() {
            return this.hardLimit;
        }

        @Override
        public final Builder hardLimit(Integer hardLimit) {
            this.hardLimit = hardLimit;
            return this;
        }

        public final void setHardLimit(Integer hardLimit) {
            this.hardLimit = hardLimit;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getSoftLimit() {
            return this.softLimit;
        }

        @Override
        public final Builder softLimit(Integer softLimit) {
            this.softLimit = softLimit;
            return this;
        }

        public final void setSoftLimit(Integer softLimit) {
            this.softLimit = softLimit;
        }

        public Ulimit build() {
            return new Ulimit(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Ulimit> {
        public Builder hardLimit(Integer var1);

        public Builder name(String var1);

        public Builder softLimit(Integer var1);
    }
}

