/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.model.CEState;
import software.amazon.awssdk.services.batch.model.CEStatus;
import software.amazon.awssdk.services.batch.model.CEType;
import software.amazon.awssdk.services.batch.model.ComputeResource;
import software.amazon.awssdk.services.batch.transform.ComputeEnvironmentDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ComputeEnvironmentDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, ComputeEnvironmentDetail> {
    private final String computeEnvironmentName;
    private final String computeEnvironmentArn;
    private final String ecsClusterArn;
    private final String type;
    private final String state;
    private final String status;
    private final String statusReason;
    private final ComputeResource computeResources;
    private final String serviceRole;

    private ComputeEnvironmentDetail(BuilderImpl builder) {
        this.computeEnvironmentName = builder.computeEnvironmentName;
        this.computeEnvironmentArn = builder.computeEnvironmentArn;
        this.ecsClusterArn = builder.ecsClusterArn;
        this.type = builder.type;
        this.state = builder.state;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.computeResources = builder.computeResources;
        this.serviceRole = builder.serviceRole;
    }

    public String computeEnvironmentName() {
        return this.computeEnvironmentName;
    }

    public String computeEnvironmentArn() {
        return this.computeEnvironmentArn;
    }

    public String ecsClusterArn() {
        return this.ecsClusterArn;
    }

    public String type() {
        return this.type;
    }

    public String state() {
        return this.state;
    }

    public String status() {
        return this.status;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public ComputeResource computeResources() {
        return this.computeResources;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.computeEnvironmentName() == null ? 0 : this.computeEnvironmentName().hashCode());
        hashCode = 31 * hashCode + (this.computeEnvironmentArn() == null ? 0 : this.computeEnvironmentArn().hashCode());
        hashCode = 31 * hashCode + (this.ecsClusterArn() == null ? 0 : this.ecsClusterArn().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.statusReason() == null ? 0 : this.statusReason().hashCode());
        hashCode = 31 * hashCode + (this.computeResources() == null ? 0 : this.computeResources().hashCode());
        hashCode = 31 * hashCode + (this.serviceRole() == null ? 0 : this.serviceRole().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeEnvironmentDetail)) {
            return false;
        }
        ComputeEnvironmentDetail other = (ComputeEnvironmentDetail)obj;
        if (other.computeEnvironmentName() == null ^ this.computeEnvironmentName() == null) {
            return false;
        }
        if (other.computeEnvironmentName() != null && !other.computeEnvironmentName().equals(this.computeEnvironmentName())) {
            return false;
        }
        if (other.computeEnvironmentArn() == null ^ this.computeEnvironmentArn() == null) {
            return false;
        }
        if (other.computeEnvironmentArn() != null && !other.computeEnvironmentArn().equals(this.computeEnvironmentArn())) {
            return false;
        }
        if (other.ecsClusterArn() == null ^ this.ecsClusterArn() == null) {
            return false;
        }
        if (other.ecsClusterArn() != null && !other.ecsClusterArn().equals(this.ecsClusterArn())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusReason() == null ^ this.statusReason() == null) {
            return false;
        }
        if (other.statusReason() != null && !other.statusReason().equals(this.statusReason())) {
            return false;
        }
        if (other.computeResources() == null ^ this.computeResources() == null) {
            return false;
        }
        if (other.computeResources() != null && !other.computeResources().equals(this.computeResources())) {
            return false;
        }
        if (other.serviceRole() == null ^ this.serviceRole() == null) {
            return false;
        }
        return other.serviceRole() == null || other.serviceRole().equals(this.serviceRole());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.computeEnvironmentName() != null) {
            sb.append("ComputeEnvironmentName: ").append(this.computeEnvironmentName()).append(",");
        }
        if (this.computeEnvironmentArn() != null) {
            sb.append("ComputeEnvironmentArn: ").append(this.computeEnvironmentArn()).append(",");
        }
        if (this.ecsClusterArn() != null) {
            sb.append("EcsClusterArn: ").append(this.ecsClusterArn()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.statusReason() != null) {
            sb.append("StatusReason: ").append(this.statusReason()).append(",");
        }
        if (this.computeResources() != null) {
            sb.append("ComputeResources: ").append(this.computeResources()).append(",");
        }
        if (this.serviceRole() != null) {
            sb.append("ServiceRole: ").append(this.serviceRole()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComputeEnvironmentDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String computeEnvironmentName;
        private String computeEnvironmentArn;
        private String ecsClusterArn;
        private String type;
        private String state;
        private String status;
        private String statusReason;
        private ComputeResource computeResources;
        private String serviceRole;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeEnvironmentDetail model) {
            this.setComputeEnvironmentName(model.computeEnvironmentName);
            this.setComputeEnvironmentArn(model.computeEnvironmentArn);
            this.setEcsClusterArn(model.ecsClusterArn);
            this.setType(model.type);
            this.setState(model.state);
            this.setStatus(model.status);
            this.setStatusReason(model.statusReason);
            this.setComputeResources(model.computeResources);
            this.setServiceRole(model.serviceRole);
        }

        public final String getComputeEnvironmentName() {
            return this.computeEnvironmentName;
        }

        @Override
        public final Builder computeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
            return this;
        }

        public final void setComputeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
        }

        public final String getComputeEnvironmentArn() {
            return this.computeEnvironmentArn;
        }

        @Override
        public final Builder computeEnvironmentArn(String computeEnvironmentArn) {
            this.computeEnvironmentArn = computeEnvironmentArn;
            return this;
        }

        public final void setComputeEnvironmentArn(String computeEnvironmentArn) {
            this.computeEnvironmentArn = computeEnvironmentArn;
        }

        public final String getEcsClusterArn() {
            return this.ecsClusterArn;
        }

        @Override
        public final Builder ecsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
            return this;
        }

        public final void setEcsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CEType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(CEType type) {
            this.type(type.toString());
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CEState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(CEState state) {
            this.state(state.toString());
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CEStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(CEStatus status) {
            this.status(status.toString());
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final ComputeResource getComputeResources() {
            return this.computeResources;
        }

        @Override
        public final Builder computeResources(ComputeResource computeResources) {
            this.computeResources = computeResources;
            return this;
        }

        public final void setComputeResources(ComputeResource computeResources) {
            this.computeResources = computeResources;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public ComputeEnvironmentDetail build() {
            return new ComputeEnvironmentDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ComputeEnvironmentDetail> {
        public Builder computeEnvironmentName(String var1);

        public Builder computeEnvironmentArn(String var1);

        public Builder ecsClusterArn(String var1);

        public Builder type(String var1);

        public Builder type(CEType var1);

        public Builder state(String var1);

        public Builder state(CEState var1);

        public Builder status(String var1);

        public Builder status(CEStatus var1);

        public Builder statusReason(String var1);

        public Builder computeResources(ComputeResource var1);

        public Builder serviceRole(String var1);
    }
}

