/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupstorage.model.BackupStorageRequest;
import software.amazon.awssdk.services.backupstorage.model.DataChecksumAlgorithm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutChunkRequest
extends BackupStorageRequest
implements ToCopyableBuilder<Builder, PutChunkRequest> {
    private static final SdkField<String> BACKUP_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupJobId").getter(PutChunkRequest.getter(PutChunkRequest::backupJobId)).setter(PutChunkRequest.setter(Builder::backupJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()}).build();
    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UploadId").getter(PutChunkRequest.getter(PutChunkRequest::uploadId)).setter(PutChunkRequest.setter(Builder::uploadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("uploadId").build()}).build();
    private static final SdkField<Long> CHUNK_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ChunkIndex").getter(PutChunkRequest.getter(PutChunkRequest::chunkIndex)).setter(PutChunkRequest.setter(Builder::chunkIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("chunkIndex").build()}).build();
    private static final SdkField<Long> LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Length").getter(PutChunkRequest.getter(PutChunkRequest::length)).setter(PutChunkRequest.setter(Builder::length)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("length").build()}).build();
    private static final SdkField<String> CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Checksum").getter(PutChunkRequest.getter(PutChunkRequest::checksum)).setter(PutChunkRequest.setter(Builder::checksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("checksum").build()}).build();
    private static final SdkField<String> CHECKSUM_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChecksumAlgorithm").getter(PutChunkRequest.getter(PutChunkRequest::checksumAlgorithmAsString)).setter(PutChunkRequest.setter(Builder::checksumAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("checksum-algorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_JOB_ID_FIELD, UPLOAD_ID_FIELD, CHUNK_INDEX_FIELD, LENGTH_FIELD, CHECKSUM_FIELD, CHECKSUM_ALGORITHM_FIELD));
    private final String backupJobId;
    private final String uploadId;
    private final Long chunkIndex;
    private final Long length;
    private final String checksum;
    private final String checksumAlgorithm;

    private PutChunkRequest(BuilderImpl builder) {
        super(builder);
        this.backupJobId = builder.backupJobId;
        this.uploadId = builder.uploadId;
        this.chunkIndex = builder.chunkIndex;
        this.length = builder.length;
        this.checksum = builder.checksum;
        this.checksumAlgorithm = builder.checksumAlgorithm;
    }

    public final String backupJobId() {
        return this.backupJobId;
    }

    public final String uploadId() {
        return this.uploadId;
    }

    public final Long chunkIndex() {
        return this.chunkIndex;
    }

    public final Long length() {
        return this.length;
    }

    public final String checksum() {
        return this.checksum;
    }

    public final DataChecksumAlgorithm checksumAlgorithm() {
        return DataChecksumAlgorithm.fromValue(this.checksumAlgorithm);
    }

    public final String checksumAlgorithmAsString() {
        return this.checksumAlgorithm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.chunkIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.length());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksumAlgorithmAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutChunkRequest)) {
            return false;
        }
        PutChunkRequest other = (PutChunkRequest)((Object)obj);
        return Objects.equals(this.backupJobId(), other.backupJobId()) && Objects.equals(this.uploadId(), other.uploadId()) && Objects.equals(this.chunkIndex(), other.chunkIndex()) && Objects.equals(this.length(), other.length()) && Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.checksumAlgorithmAsString(), other.checksumAlgorithmAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutChunkRequest").add("BackupJobId", (Object)this.backupJobId()).add("UploadId", (Object)this.uploadId()).add("ChunkIndex", (Object)this.chunkIndex()).add("Length", (Object)this.length()).add("Checksum", (Object)this.checksum()).add("ChecksumAlgorithm", (Object)this.checksumAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupJobId": {
                return Optional.ofNullable(clazz.cast(this.backupJobId()));
            }
            case "UploadId": {
                return Optional.ofNullable(clazz.cast(this.uploadId()));
            }
            case "ChunkIndex": {
                return Optional.ofNullable(clazz.cast(this.chunkIndex()));
            }
            case "Length": {
                return Optional.ofNullable(clazz.cast(this.length()));
            }
            case "Checksum": {
                return Optional.ofNullable(clazz.cast(this.checksum()));
            }
            case "ChecksumAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.checksumAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutChunkRequest, T> g) {
        return obj -> g.apply((PutChunkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupStorageRequest.BuilderImpl
    implements Builder {
        private String backupJobId;
        private String uploadId;
        private Long chunkIndex;
        private Long length;
        private String checksum;
        private String checksumAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(PutChunkRequest model) {
            super(model);
            this.backupJobId(model.backupJobId);
            this.uploadId(model.uploadId);
            this.chunkIndex(model.chunkIndex);
            this.length(model.length);
            this.checksum(model.checksum);
            this.checksumAlgorithm(model.checksumAlgorithm);
        }

        public final String getBackupJobId() {
            return this.backupJobId;
        }

        public final void setBackupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
        }

        @Override
        public final Builder backupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
            return this;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final Long getChunkIndex() {
            return this.chunkIndex;
        }

        public final void setChunkIndex(Long chunkIndex) {
            this.chunkIndex = chunkIndex;
        }

        @Override
        public final Builder chunkIndex(Long chunkIndex) {
            this.chunkIndex = chunkIndex;
            return this;
        }

        public final Long getLength() {
            return this.length;
        }

        public final void setLength(Long length) {
            this.length = length;
        }

        @Override
        public final Builder length(Long length) {
            this.length = length;
            return this;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final String getChecksumAlgorithm() {
            return this.checksumAlgorithm;
        }

        public final void setChecksumAlgorithm(String checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
        }

        @Override
        public final Builder checksumAlgorithm(String checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
            return this;
        }

        @Override
        public final Builder checksumAlgorithm(DataChecksumAlgorithm checksumAlgorithm) {
            this.checksumAlgorithm(checksumAlgorithm == null ? null : checksumAlgorithm.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutChunkRequest build() {
            return new PutChunkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupStorageRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutChunkRequest> {
        public Builder backupJobId(String var1);

        public Builder uploadId(String var1);

        public Builder chunkIndex(Long var1);

        public Builder length(Long var1);

        public Builder checksum(String var1);

        public Builder checksumAlgorithm(String var1);

        public Builder checksumAlgorithm(DataChecksumAlgorithm var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

