/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutChunkResponse extends BackupStorageResponse implements
        ToCopyableBuilder<PutChunkResponse.Builder, PutChunkResponse> {
    private static final SdkField<String> CHUNK_CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChunkChecksum").getter(getter(PutChunkResponse::chunkChecksum)).setter(setter(Builder::chunkChecksum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChunkChecksum").build()).build();

    private static final SdkField<String> CHUNK_CHECKSUM_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChunkChecksumAlgorithm").getter(getter(PutChunkResponse::chunkChecksumAlgorithmAsString))
            .setter(setter(Builder::chunkChecksumAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChunkChecksumAlgorithm").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHUNK_CHECKSUM_FIELD,
            CHUNK_CHECKSUM_ALGORITHM_FIELD));

    private final String chunkChecksum;

    private final String chunkChecksumAlgorithm;

    private PutChunkResponse(BuilderImpl builder) {
        super(builder);
        this.chunkChecksum = builder.chunkChecksum;
        this.chunkChecksumAlgorithm = builder.chunkChecksumAlgorithm;
    }

    /**
     * Chunk checksum
     * 
     * @return Chunk checksum
     */
    public final String chunkChecksum() {
        return chunkChecksum;
    }

    /**
     * Checksum algorithm
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #chunkChecksumAlgorithm} will return {@link DataChecksumAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #chunkChecksumAlgorithmAsString}.
     * </p>
     * 
     * @return Checksum algorithm
     * @see DataChecksumAlgorithm
     */
    public final DataChecksumAlgorithm chunkChecksumAlgorithm() {
        return DataChecksumAlgorithm.fromValue(chunkChecksumAlgorithm);
    }

    /**
     * Checksum algorithm
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #chunkChecksumAlgorithm} will return {@link DataChecksumAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #chunkChecksumAlgorithmAsString}.
     * </p>
     * 
     * @return Checksum algorithm
     * @see DataChecksumAlgorithm
     */
    public final String chunkChecksumAlgorithmAsString() {
        return chunkChecksumAlgorithm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(chunkChecksum());
        hashCode = 31 * hashCode + Objects.hashCode(chunkChecksumAlgorithmAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutChunkResponse)) {
            return false;
        }
        PutChunkResponse other = (PutChunkResponse) obj;
        return Objects.equals(chunkChecksum(), other.chunkChecksum())
                && Objects.equals(chunkChecksumAlgorithmAsString(), other.chunkChecksumAlgorithmAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutChunkResponse").add("ChunkChecksum", chunkChecksum())
                .add("ChunkChecksumAlgorithm", chunkChecksumAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChunkChecksum":
            return Optional.ofNullable(clazz.cast(chunkChecksum()));
        case "ChunkChecksumAlgorithm":
            return Optional.ofNullable(clazz.cast(chunkChecksumAlgorithmAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutChunkResponse, T> g) {
        return obj -> g.apply((PutChunkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupStorageResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutChunkResponse> {
        /**
         * Chunk checksum
         * 
         * @param chunkChecksum
         *        Chunk checksum
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chunkChecksum(String chunkChecksum);

        /**
         * Checksum algorithm
         * 
         * @param chunkChecksumAlgorithm
         *        Checksum algorithm
         * @see DataChecksumAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataChecksumAlgorithm
         */
        Builder chunkChecksumAlgorithm(String chunkChecksumAlgorithm);

        /**
         * Checksum algorithm
         * 
         * @param chunkChecksumAlgorithm
         *        Checksum algorithm
         * @see DataChecksumAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataChecksumAlgorithm
         */
        Builder chunkChecksumAlgorithm(DataChecksumAlgorithm chunkChecksumAlgorithm);
    }

    static final class BuilderImpl extends BackupStorageResponse.BuilderImpl implements Builder {
        private String chunkChecksum;

        private String chunkChecksumAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(PutChunkResponse model) {
            super(model);
            chunkChecksum(model.chunkChecksum);
            chunkChecksumAlgorithm(model.chunkChecksumAlgorithm);
        }

        public final String getChunkChecksum() {
            return chunkChecksum;
        }

        public final void setChunkChecksum(String chunkChecksum) {
            this.chunkChecksum = chunkChecksum;
        }

        @Override
        public final Builder chunkChecksum(String chunkChecksum) {
            this.chunkChecksum = chunkChecksum;
            return this;
        }

        public final String getChunkChecksumAlgorithm() {
            return chunkChecksumAlgorithm;
        }

        public final void setChunkChecksumAlgorithm(String chunkChecksumAlgorithm) {
            this.chunkChecksumAlgorithm = chunkChecksumAlgorithm;
        }

        @Override
        public final Builder chunkChecksumAlgorithm(String chunkChecksumAlgorithm) {
            this.chunkChecksumAlgorithm = chunkChecksumAlgorithm;
            return this;
        }

        @Override
        public final Builder chunkChecksumAlgorithm(DataChecksumAlgorithm chunkChecksumAlgorithm) {
            this.chunkChecksumAlgorithm(chunkChecksumAlgorithm == null ? null : chunkChecksumAlgorithm.toString());
            return this;
        }

        @Override
        public PutChunkResponse build() {
            return new PutChunkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
