/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupstorage.model.BackupStorageResponse;
import software.amazon.awssdk.services.backupstorage.model.DataChecksumAlgorithm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutChunkResponse
extends BackupStorageResponse
implements ToCopyableBuilder<Builder, PutChunkResponse> {
    private static final SdkField<String> CHUNK_CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChunkChecksum").getter(PutChunkResponse.getter(PutChunkResponse::chunkChecksum)).setter(PutChunkResponse.setter(Builder::chunkChecksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChunkChecksum").build()}).build();
    private static final SdkField<String> CHUNK_CHECKSUM_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChunkChecksumAlgorithm").getter(PutChunkResponse.getter(PutChunkResponse::chunkChecksumAlgorithmAsString)).setter(PutChunkResponse.setter(Builder::chunkChecksumAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChunkChecksumAlgorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHUNK_CHECKSUM_FIELD, CHUNK_CHECKSUM_ALGORITHM_FIELD));
    private final String chunkChecksum;
    private final String chunkChecksumAlgorithm;

    private PutChunkResponse(BuilderImpl builder) {
        super(builder);
        this.chunkChecksum = builder.chunkChecksum;
        this.chunkChecksumAlgorithm = builder.chunkChecksumAlgorithm;
    }

    public final String chunkChecksum() {
        return this.chunkChecksum;
    }

    public final DataChecksumAlgorithm chunkChecksumAlgorithm() {
        return DataChecksumAlgorithm.fromValue(this.chunkChecksumAlgorithm);
    }

    public final String chunkChecksumAlgorithmAsString() {
        return this.chunkChecksumAlgorithm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.chunkChecksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.chunkChecksumAlgorithmAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutChunkResponse)) {
            return false;
        }
        PutChunkResponse other = (PutChunkResponse)((Object)obj);
        return Objects.equals(this.chunkChecksum(), other.chunkChecksum()) && Objects.equals(this.chunkChecksumAlgorithmAsString(), other.chunkChecksumAlgorithmAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutChunkResponse").add("ChunkChecksum", (Object)this.chunkChecksum()).add("ChunkChecksumAlgorithm", (Object)this.chunkChecksumAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChunkChecksum": {
                return Optional.ofNullable(clazz.cast(this.chunkChecksum()));
            }
            case "ChunkChecksumAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.chunkChecksumAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutChunkResponse, T> g) {
        return obj -> g.apply((PutChunkResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupStorageResponse.BuilderImpl
    implements Builder {
        private String chunkChecksum;
        private String chunkChecksumAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(PutChunkResponse model) {
            super(model);
            this.chunkChecksum(model.chunkChecksum);
            this.chunkChecksumAlgorithm(model.chunkChecksumAlgorithm);
        }

        public final String getChunkChecksum() {
            return this.chunkChecksum;
        }

        public final void setChunkChecksum(String chunkChecksum) {
            this.chunkChecksum = chunkChecksum;
        }

        @Override
        public final Builder chunkChecksum(String chunkChecksum) {
            this.chunkChecksum = chunkChecksum;
            return this;
        }

        public final String getChunkChecksumAlgorithm() {
            return this.chunkChecksumAlgorithm;
        }

        public final void setChunkChecksumAlgorithm(String chunkChecksumAlgorithm) {
            this.chunkChecksumAlgorithm = chunkChecksumAlgorithm;
        }

        @Override
        public final Builder chunkChecksumAlgorithm(String chunkChecksumAlgorithm) {
            this.chunkChecksumAlgorithm = chunkChecksumAlgorithm;
            return this;
        }

        @Override
        public final Builder chunkChecksumAlgorithm(DataChecksumAlgorithm chunkChecksumAlgorithm) {
            this.chunkChecksumAlgorithm(chunkChecksumAlgorithm == null ? null : chunkChecksumAlgorithm.toString());
            return this;
        }

        @Override
        public PutChunkResponse build() {
            return new PutChunkResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupStorageResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutChunkResponse> {
        public Builder chunkChecksum(String var1);

        public Builder chunkChecksumAlgorithm(String var1);

        public Builder chunkChecksumAlgorithm(DataChecksumAlgorithm var1);
    }
}

