/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backupsearch.model.EBSResultItem;
import software.amazon.awssdk.services.backupsearch.model.S3ResultItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResultItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResultItem> {
    private static final SdkField<S3ResultItem> S3_RESULT_ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3ResultItem").getter(ResultItem.getter(ResultItem::s3ResultItem)).setter(ResultItem.setter(Builder::s3ResultItem)).constructor(S3ResultItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ResultItem").build()}).build();
    private static final SdkField<EBSResultItem> EBS_RESULT_ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EBSResultItem").getter(ResultItem.getter(ResultItem::ebsResultItem)).setter(ResultItem.setter(Builder::ebsResultItem)).constructor(EBSResultItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EBSResultItem").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_RESULT_ITEM_FIELD, EBS_RESULT_ITEM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResultItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final S3ResultItem s3ResultItem;
    private final EBSResultItem ebsResultItem;
    private final Type type;

    private ResultItem(BuilderImpl builder) {
        this.s3ResultItem = builder.s3ResultItem;
        this.ebsResultItem = builder.ebsResultItem;
        this.type = builder.type;
    }

    public final S3ResultItem s3ResultItem() {
        return this.s3ResultItem;
    }

    public final EBSResultItem ebsResultItem() {
        return this.ebsResultItem;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ResultItem());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsResultItem());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultItem)) {
            return false;
        }
        ResultItem other = (ResultItem)obj;
        return Objects.equals(this.s3ResultItem(), other.s3ResultItem()) && Objects.equals(this.ebsResultItem(), other.ebsResultItem());
    }

    public final String toString() {
        return ToString.builder((String)"ResultItem").add("S3ResultItem", (Object)this.s3ResultItem()).add("EBSResultItem", (Object)this.ebsResultItem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3ResultItem": {
                return Optional.ofNullable(clazz.cast(this.s3ResultItem()));
            }
            case "EBSResultItem": {
                return Optional.ofNullable(clazz.cast(this.ebsResultItem()));
            }
        }
        return Optional.empty();
    }

    public static ResultItem fromS3ResultItem(S3ResultItem s3ResultItem) {
        return (ResultItem)ResultItem.builder().s3ResultItem(s3ResultItem).build();
    }

    public static ResultItem fromS3ResultItem(Consumer<S3ResultItem.Builder> s3ResultItem) {
        S3ResultItem.Builder builder = S3ResultItem.builder();
        s3ResultItem.accept(builder);
        return ResultItem.fromS3ResultItem((S3ResultItem)builder.build());
    }

    public static ResultItem fromEbsResultItem(EBSResultItem ebsResultItem) {
        return (ResultItem)ResultItem.builder().ebsResultItem(ebsResultItem).build();
    }

    public static ResultItem fromEbsResultItem(Consumer<EBSResultItem.Builder> ebsResultItem) {
        EBSResultItem.Builder builder = EBSResultItem.builder();
        ebsResultItem.accept(builder);
        return ResultItem.fromEbsResultItem((EBSResultItem)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("S3ResultItem", S3_RESULT_ITEM_FIELD);
        map.put("EBSResultItem", EBS_RESULT_ITEM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResultItem, T> g) {
        return obj -> g.apply((ResultItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        S3_RESULT_ITEM,
        EBS_RESULT_ITEM,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private S3ResultItem s3ResultItem;
        private EBSResultItem ebsResultItem;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ResultItem model) {
            this.s3ResultItem(model.s3ResultItem);
            this.ebsResultItem(model.ebsResultItem);
        }

        public final S3ResultItem.Builder getS3ResultItem() {
            return this.s3ResultItem != null ? this.s3ResultItem.toBuilder() : null;
        }

        public final void setS3ResultItem(S3ResultItem.BuilderImpl s3ResultItem) {
            S3ResultItem oldValue = this.s3ResultItem;
            this.s3ResultItem = s3ResultItem != null ? s3ResultItem.build() : null;
            this.handleUnionValueChange(Type.S3_RESULT_ITEM, oldValue, this.s3ResultItem);
        }

        @Override
        public final Builder s3ResultItem(S3ResultItem s3ResultItem) {
            S3ResultItem oldValue = this.s3ResultItem;
            this.s3ResultItem = s3ResultItem;
            this.handleUnionValueChange(Type.S3_RESULT_ITEM, oldValue, this.s3ResultItem);
            return this;
        }

        public final EBSResultItem.Builder getEbsResultItem() {
            return this.ebsResultItem != null ? this.ebsResultItem.toBuilder() : null;
        }

        public final void setEbsResultItem(EBSResultItem.BuilderImpl ebsResultItem) {
            EBSResultItem oldValue = this.ebsResultItem;
            this.ebsResultItem = ebsResultItem != null ? ebsResultItem.build() : null;
            this.handleUnionValueChange(Type.EBS_RESULT_ITEM, oldValue, this.ebsResultItem);
        }

        @Override
        public final Builder ebsResultItem(EBSResultItem ebsResultItem) {
            EBSResultItem oldValue = this.ebsResultItem;
            this.ebsResultItem = ebsResultItem;
            this.handleUnionValueChange(Type.EBS_RESULT_ITEM, oldValue, this.ebsResultItem);
            return this;
        }

        public ResultItem build() {
            return new ResultItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResultItem> {
        public Builder s3ResultItem(S3ResultItem var1);

        default public Builder s3ResultItem(Consumer<S3ResultItem.Builder> s3ResultItem) {
            return this.s3ResultItem((S3ResultItem)((S3ResultItem.Builder)S3ResultItem.builder().applyMutation(s3ResultItem)).build());
        }

        public Builder ebsResultItem(EBSResultItem var1);

        default public Builder ebsResultItem(Consumer<EBSResultItem.Builder> ebsResultItem) {
            return this.ebsResultItem((EBSResultItem)((EBSResultItem.Builder)EBSResultItem.builder().applyMutation(ebsResultItem)).build());
        }
    }
}

