/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupsearch.model.SearchJobState;
import software.amazon.awssdk.services.backupsearch.model.SearchScopeSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchJobSummary> {
    private static final SdkField<String> SEARCH_JOB_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SearchJobIdentifier").getter(SearchJobSummary.getter(SearchJobSummary::searchJobIdentifier)).setter(SearchJobSummary.setter(Builder::searchJobIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchJobIdentifier").build()}).build();
    private static final SdkField<String> SEARCH_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SearchJobArn").getter(SearchJobSummary.getter(SearchJobSummary::searchJobArn)).setter(SearchJobSummary.setter(Builder::searchJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchJobArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(SearchJobSummary.getter(SearchJobSummary::name)).setter(SearchJobSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SearchJobSummary.getter(SearchJobSummary::statusAsString)).setter(SearchJobSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(SearchJobSummary.getter(SearchJobSummary::creationTime)).setter(SearchJobSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionTime").getter(SearchJobSummary.getter(SearchJobSummary::completionTime)).setter(SearchJobSummary.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()}).build();
    private static final SdkField<SearchScopeSummary> SEARCH_SCOPE_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SearchScopeSummary").getter(SearchJobSummary.getter(SearchJobSummary::searchScopeSummary)).setter(SearchJobSummary.setter(Builder::searchScopeSummary)).constructor(SearchScopeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchScopeSummary").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(SearchJobSummary.getter(SearchJobSummary::statusMessage)).setter(SearchJobSummary.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_JOB_IDENTIFIER_FIELD, SEARCH_JOB_ARN_FIELD, NAME_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, COMPLETION_TIME_FIELD, SEARCH_SCOPE_SUMMARY_FIELD, STATUS_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchJobSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String searchJobIdentifier;
    private final String searchJobArn;
    private final String name;
    private final String status;
    private final Instant creationTime;
    private final Instant completionTime;
    private final SearchScopeSummary searchScopeSummary;
    private final String statusMessage;

    private SearchJobSummary(BuilderImpl builder) {
        this.searchJobIdentifier = builder.searchJobIdentifier;
        this.searchJobArn = builder.searchJobArn;
        this.name = builder.name;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.completionTime = builder.completionTime;
        this.searchScopeSummary = builder.searchScopeSummary;
        this.statusMessage = builder.statusMessage;
    }

    public final String searchJobIdentifier() {
        return this.searchJobIdentifier;
    }

    public final String searchJobArn() {
        return this.searchJobArn;
    }

    public final String name() {
        return this.name;
    }

    public final SearchJobState status() {
        return SearchJobState.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final SearchScopeSummary searchScopeSummary() {
        return this.searchScopeSummary;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.searchJobIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchScopeSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchJobSummary)) {
            return false;
        }
        SearchJobSummary other = (SearchJobSummary)obj;
        return Objects.equals(this.searchJobIdentifier(), other.searchJobIdentifier()) && Objects.equals(this.searchJobArn(), other.searchJobArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.searchScopeSummary(), other.searchScopeSummary()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"SearchJobSummary").add("SearchJobIdentifier", (Object)this.searchJobIdentifier()).add("SearchJobArn", (Object)this.searchJobArn()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("CompletionTime", (Object)this.completionTime()).add("SearchScopeSummary", (Object)this.searchScopeSummary()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SearchJobIdentifier": {
                return Optional.ofNullable(clazz.cast(this.searchJobIdentifier()));
            }
            case "SearchJobArn": {
                return Optional.ofNullable(clazz.cast(this.searchJobArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CompletionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "SearchScopeSummary": {
                return Optional.ofNullable(clazz.cast(this.searchScopeSummary()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SearchJobIdentifier", SEARCH_JOB_IDENTIFIER_FIELD);
        map.put("SearchJobArn", SEARCH_JOB_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("CompletionTime", COMPLETION_TIME_FIELD);
        map.put("SearchScopeSummary", SEARCH_SCOPE_SUMMARY_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchJobSummary, T> g) {
        return obj -> g.apply((SearchJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String searchJobIdentifier;
        private String searchJobArn;
        private String name;
        private String status;
        private Instant creationTime;
        private Instant completionTime;
        private SearchScopeSummary searchScopeSummary;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchJobSummary model) {
            this.searchJobIdentifier(model.searchJobIdentifier);
            this.searchJobArn(model.searchJobArn);
            this.name(model.name);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.completionTime(model.completionTime);
            this.searchScopeSummary(model.searchScopeSummary);
            this.statusMessage(model.statusMessage);
        }

        public final String getSearchJobIdentifier() {
            return this.searchJobIdentifier;
        }

        public final void setSearchJobIdentifier(String searchJobIdentifier) {
            this.searchJobIdentifier = searchJobIdentifier;
        }

        @Override
        public final Builder searchJobIdentifier(String searchJobIdentifier) {
            this.searchJobIdentifier = searchJobIdentifier;
            return this;
        }

        public final String getSearchJobArn() {
            return this.searchJobArn;
        }

        public final void setSearchJobArn(String searchJobArn) {
            this.searchJobArn = searchJobArn;
        }

        @Override
        public final Builder searchJobArn(String searchJobArn) {
            this.searchJobArn = searchJobArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SearchJobState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final SearchScopeSummary.Builder getSearchScopeSummary() {
            return this.searchScopeSummary != null ? this.searchScopeSummary.toBuilder() : null;
        }

        public final void setSearchScopeSummary(SearchScopeSummary.BuilderImpl searchScopeSummary) {
            this.searchScopeSummary = searchScopeSummary != null ? searchScopeSummary.build() : null;
        }

        @Override
        public final Builder searchScopeSummary(SearchScopeSummary searchScopeSummary) {
            this.searchScopeSummary = searchScopeSummary;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public SearchJobSummary build() {
            return new SearchJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchJobSummary> {
        public Builder searchJobIdentifier(String var1);

        public Builder searchJobArn(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(SearchJobState var1);

        public Builder creationTime(Instant var1);

        public Builder completionTime(Instant var1);

        public Builder searchScopeSummary(SearchScopeSummary var1);

        default public Builder searchScopeSummary(Consumer<SearchScopeSummary.Builder> searchScopeSummary) {
            return this.searchScopeSummary((SearchScopeSummary)((SearchScopeSummary.Builder)SearchScopeSummary.builder().applyMutation(searchScopeSummary)).build());
        }

        public Builder statusMessage(String var1);
    }
}

