/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backupsearch.BackupSearchClient;
import software.amazon.awssdk.services.backupsearch.internal.UserAgentUtils;
import software.amazon.awssdk.services.backupsearch.model.ExportJobSummary;
import software.amazon.awssdk.services.backupsearch.model.ListSearchResultExportJobsRequest;
import software.amazon.awssdk.services.backupsearch.model.ListSearchResultExportJobsResponse;

public class ListSearchResultExportJobsIterable
implements SdkIterable<ListSearchResultExportJobsResponse> {
    private final BackupSearchClient client;
    private final ListSearchResultExportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSearchResultExportJobsIterable(BackupSearchClient client, ListSearchResultExportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSearchResultExportJobsResponseFetcher();
    }

    public Iterator<ListSearchResultExportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ExportJobSummary> exportJobs() {
        Function<ListSearchResultExportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.exportJobs() != null) {
                return response.exportJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSearchResultExportJobsResponseFetcher
    implements SyncPageFetcher<ListSearchResultExportJobsResponse> {
        private ListSearchResultExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListSearchResultExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSearchResultExportJobsResponse nextPage(ListSearchResultExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListSearchResultExportJobsIterable.this.client.listSearchResultExportJobs(ListSearchResultExportJobsIterable.this.firstRequest);
            }
            return ListSearchResultExportJobsIterable.this.client.listSearchResultExportJobs((ListSearchResultExportJobsRequest)((Object)ListSearchResultExportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

