/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupgateway.model.BackupGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutMaintenanceStartTimeRequest
extends BackupGatewayRequest
implements ToCopyableBuilder<Builder, PutMaintenanceStartTimeRequest> {
    private static final SdkField<Integer> DAY_OF_MONTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DayOfMonth").getter(PutMaintenanceStartTimeRequest.getter(PutMaintenanceStartTimeRequest::dayOfMonth)).setter(PutMaintenanceStartTimeRequest.setter(Builder::dayOfMonth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfMonth").build()}).build();
    private static final SdkField<Integer> DAY_OF_WEEK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DayOfWeek").getter(PutMaintenanceStartTimeRequest.getter(PutMaintenanceStartTimeRequest::dayOfWeek)).setter(PutMaintenanceStartTimeRequest.setter(Builder::dayOfWeek)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfWeek").build()}).build();
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayArn").getter(PutMaintenanceStartTimeRequest.getter(PutMaintenanceStartTimeRequest::gatewayArn)).setter(PutMaintenanceStartTimeRequest.setter(Builder::gatewayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayArn").build()}).build();
    private static final SdkField<Integer> HOUR_OF_DAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HourOfDay").getter(PutMaintenanceStartTimeRequest.getter(PutMaintenanceStartTimeRequest::hourOfDay)).setter(PutMaintenanceStartTimeRequest.setter(Builder::hourOfDay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourOfDay").build()}).build();
    private static final SdkField<Integer> MINUTE_OF_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinuteOfHour").getter(PutMaintenanceStartTimeRequest.getter(PutMaintenanceStartTimeRequest::minuteOfHour)).setter(PutMaintenanceStartTimeRequest.setter(Builder::minuteOfHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinuteOfHour").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAY_OF_MONTH_FIELD, DAY_OF_WEEK_FIELD, GATEWAY_ARN_FIELD, HOUR_OF_DAY_FIELD, MINUTE_OF_HOUR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutMaintenanceStartTimeRequest.memberNameToFieldInitializer();
    private final Integer dayOfMonth;
    private final Integer dayOfWeek;
    private final String gatewayArn;
    private final Integer hourOfDay;
    private final Integer minuteOfHour;

    private PutMaintenanceStartTimeRequest(BuilderImpl builder) {
        super(builder);
        this.dayOfMonth = builder.dayOfMonth;
        this.dayOfWeek = builder.dayOfWeek;
        this.gatewayArn = builder.gatewayArn;
        this.hourOfDay = builder.hourOfDay;
        this.minuteOfHour = builder.minuteOfHour;
    }

    public final Integer dayOfMonth() {
        return this.dayOfMonth;
    }

    public final Integer dayOfWeek() {
        return this.dayOfWeek;
    }

    public final String gatewayArn() {
        return this.gatewayArn;
    }

    public final Integer hourOfDay() {
        return this.hourOfDay;
    }

    public final Integer minuteOfHour() {
        return this.minuteOfHour;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dayOfMonth());
        hashCode = 31 * hashCode + Objects.hashCode(this.dayOfWeek());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hourOfDay());
        hashCode = 31 * hashCode + Objects.hashCode(this.minuteOfHour());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMaintenanceStartTimeRequest)) {
            return false;
        }
        PutMaintenanceStartTimeRequest other = (PutMaintenanceStartTimeRequest)((Object)obj);
        return Objects.equals(this.dayOfMonth(), other.dayOfMonth()) && Objects.equals(this.dayOfWeek(), other.dayOfWeek()) && Objects.equals(this.gatewayArn(), other.gatewayArn()) && Objects.equals(this.hourOfDay(), other.hourOfDay()) && Objects.equals(this.minuteOfHour(), other.minuteOfHour());
    }

    public final String toString() {
        return ToString.builder((String)"PutMaintenanceStartTimeRequest").add("DayOfMonth", (Object)this.dayOfMonth()).add("DayOfWeek", (Object)this.dayOfWeek()).add("GatewayArn", (Object)this.gatewayArn()).add("HourOfDay", (Object)this.hourOfDay()).add("MinuteOfHour", (Object)this.minuteOfHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DayOfMonth": {
                return Optional.ofNullable(clazz.cast(this.dayOfMonth()));
            }
            case "DayOfWeek": {
                return Optional.ofNullable(clazz.cast(this.dayOfWeek()));
            }
            case "GatewayArn": {
                return Optional.ofNullable(clazz.cast(this.gatewayArn()));
            }
            case "HourOfDay": {
                return Optional.ofNullable(clazz.cast(this.hourOfDay()));
            }
            case "MinuteOfHour": {
                return Optional.ofNullable(clazz.cast(this.minuteOfHour()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DayOfMonth", DAY_OF_MONTH_FIELD);
        map.put("DayOfWeek", DAY_OF_WEEK_FIELD);
        map.put("GatewayArn", GATEWAY_ARN_FIELD);
        map.put("HourOfDay", HOUR_OF_DAY_FIELD);
        map.put("MinuteOfHour", MINUTE_OF_HOUR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutMaintenanceStartTimeRequest, T> g) {
        return obj -> g.apply((PutMaintenanceStartTimeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupGatewayRequest.BuilderImpl
    implements Builder {
        private Integer dayOfMonth;
        private Integer dayOfWeek;
        private String gatewayArn;
        private Integer hourOfDay;
        private Integer minuteOfHour;

        private BuilderImpl() {
        }

        private BuilderImpl(PutMaintenanceStartTimeRequest model) {
            super(model);
            this.dayOfMonth(model.dayOfMonth);
            this.dayOfWeek(model.dayOfWeek);
            this.gatewayArn(model.gatewayArn);
            this.hourOfDay(model.hourOfDay);
            this.minuteOfHour(model.minuteOfHour);
        }

        public final Integer getDayOfMonth() {
            return this.dayOfMonth;
        }

        public final void setDayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
        }

        @Override
        public final Builder dayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        public final Integer getDayOfWeek() {
            return this.dayOfWeek;
        }

        public final void setDayOfWeek(Integer dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        public final Builder dayOfWeek(Integer dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        public final String getGatewayArn() {
            return this.gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        public final Integer getHourOfDay() {
            return this.hourOfDay;
        }

        public final void setHourOfDay(Integer hourOfDay) {
            this.hourOfDay = hourOfDay;
        }

        @Override
        public final Builder hourOfDay(Integer hourOfDay) {
            this.hourOfDay = hourOfDay;
            return this;
        }

        public final Integer getMinuteOfHour() {
            return this.minuteOfHour;
        }

        public final void setMinuteOfHour(Integer minuteOfHour) {
            this.minuteOfHour = minuteOfHour;
        }

        @Override
        public final Builder minuteOfHour(Integer minuteOfHour) {
            this.minuteOfHour = minuteOfHour;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMaintenanceStartTimeRequest build() {
            return new PutMaintenanceStartTimeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutMaintenanceStartTimeRequest> {
        public Builder dayOfMonth(Integer var1);

        public Builder dayOfWeek(Integer var1);

        public Builder gatewayArn(String var1);

        public Builder hourOfDay(Integer var1);

        public Builder minuteOfHour(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

