/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SyncMetadataStatus {
    CREATED("CREATED"),
    RUNNING("RUNNING"),
    FAILED("FAILED"),
    PARTIALLY_FAILED("PARTIALLY_FAILED"),
    SUCCEEDED("SUCCEEDED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SyncMetadataStatus> VALUE_MAP;
    private final String value;

    private SyncMetadataStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SyncMetadataStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SyncMetadataStatus> knownValues() {
        EnumSet<SyncMetadataStatus> knownValues = EnumSet.allOf(SyncMetadataStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SyncMetadataStatus.class, SyncMetadataStatus::toString);
    }
}

