/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backupgateway.BackupGatewayAsyncClient;
import software.amazon.awssdk.services.backupgateway.internal.UserAgentUtils;
import software.amazon.awssdk.services.backupgateway.model.Hypervisor;
import software.amazon.awssdk.services.backupgateway.model.ListHypervisorsRequest;
import software.amazon.awssdk.services.backupgateway.model.ListHypervisorsResponse;

public class ListHypervisorsPublisher
implements SdkPublisher<ListHypervisorsResponse> {
    private final BackupGatewayAsyncClient client;
    private final ListHypervisorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListHypervisorsPublisher(BackupGatewayAsyncClient client, ListHypervisorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListHypervisorsPublisher(BackupGatewayAsyncClient client, ListHypervisorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListHypervisorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListHypervisorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Hypervisor> hypervisors() {
        Function<ListHypervisorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.hypervisors() != null) {
                return response.hypervisors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListHypervisorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListHypervisorsResponseFetcher
    implements AsyncPageFetcher<ListHypervisorsResponse> {
        private ListHypervisorsResponseFetcher() {
        }

        public boolean hasNextPage(ListHypervisorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListHypervisorsResponse> nextPage(ListHypervisorsResponse previousPage) {
            if (previousPage == null) {
                return ListHypervisorsPublisher.this.client.listHypervisors(ListHypervisorsPublisher.this.firstRequest);
            }
            return ListHypervisorsPublisher.this.client.listHypervisors((ListHypervisorsRequest)((Object)ListHypervisorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

