/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backupgateway.model.BackupGatewayResponse;
import software.amazon.awssdk.services.backupgateway.model.VmwareToAwsTagMapping;
import software.amazon.awssdk.services.backupgateway.model.VmwareToAwsTagMappingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetHypervisorPropertyMappingsResponse
extends BackupGatewayResponse
implements ToCopyableBuilder<Builder, GetHypervisorPropertyMappingsResponse> {
    private static final SdkField<String> HYPERVISOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HypervisorArn").getter(GetHypervisorPropertyMappingsResponse.getter(GetHypervisorPropertyMappingsResponse::hypervisorArn)).setter(GetHypervisorPropertyMappingsResponse.setter(Builder::hypervisorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HypervisorArn").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(GetHypervisorPropertyMappingsResponse.getter(GetHypervisorPropertyMappingsResponse::iamRoleArn)).setter(GetHypervisorPropertyMappingsResponse.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<List<VmwareToAwsTagMapping>> VMWARE_TO_AWS_TAG_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VmwareToAwsTagMappings").getter(GetHypervisorPropertyMappingsResponse.getter(GetHypervisorPropertyMappingsResponse::vmwareToAwsTagMappings)).setter(GetHypervisorPropertyMappingsResponse.setter(Builder::vmwareToAwsTagMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VmwareToAwsTagMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VmwareToAwsTagMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HYPERVISOR_ARN_FIELD, IAM_ROLE_ARN_FIELD, VMWARE_TO_AWS_TAG_MAPPINGS_FIELD));
    private final String hypervisorArn;
    private final String iamRoleArn;
    private final List<VmwareToAwsTagMapping> vmwareToAwsTagMappings;

    private GetHypervisorPropertyMappingsResponse(BuilderImpl builder) {
        super(builder);
        this.hypervisorArn = builder.hypervisorArn;
        this.iamRoleArn = builder.iamRoleArn;
        this.vmwareToAwsTagMappings = builder.vmwareToAwsTagMappings;
    }

    public final String hypervisorArn() {
        return this.hypervisorArn;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final boolean hasVmwareToAwsTagMappings() {
        return this.vmwareToAwsTagMappings != null && !(this.vmwareToAwsTagMappings instanceof SdkAutoConstructList);
    }

    public final List<VmwareToAwsTagMapping> vmwareToAwsTagMappings() {
        return this.vmwareToAwsTagMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hypervisorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVmwareToAwsTagMappings() ? this.vmwareToAwsTagMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHypervisorPropertyMappingsResponse)) {
            return false;
        }
        GetHypervisorPropertyMappingsResponse other = (GetHypervisorPropertyMappingsResponse)((Object)obj);
        return Objects.equals(this.hypervisorArn(), other.hypervisorArn()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && this.hasVmwareToAwsTagMappings() == other.hasVmwareToAwsTagMappings() && Objects.equals(this.vmwareToAwsTagMappings(), other.vmwareToAwsTagMappings());
    }

    public final String toString() {
        return ToString.builder((String)"GetHypervisorPropertyMappingsResponse").add("HypervisorArn", (Object)this.hypervisorArn()).add("IamRoleArn", (Object)this.iamRoleArn()).add("VmwareToAwsTagMappings", this.hasVmwareToAwsTagMappings() ? this.vmwareToAwsTagMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HypervisorArn": {
                return Optional.ofNullable(clazz.cast(this.hypervisorArn()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "VmwareToAwsTagMappings": {
                return Optional.ofNullable(clazz.cast(this.vmwareToAwsTagMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetHypervisorPropertyMappingsResponse, T> g) {
        return obj -> g.apply((GetHypervisorPropertyMappingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupGatewayResponse.BuilderImpl
    implements Builder {
        private String hypervisorArn;
        private String iamRoleArn;
        private List<VmwareToAwsTagMapping> vmwareToAwsTagMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetHypervisorPropertyMappingsResponse model) {
            super(model);
            this.hypervisorArn(model.hypervisorArn);
            this.iamRoleArn(model.iamRoleArn);
            this.vmwareToAwsTagMappings(model.vmwareToAwsTagMappings);
        }

        public final String getHypervisorArn() {
            return this.hypervisorArn;
        }

        public final void setHypervisorArn(String hypervisorArn) {
            this.hypervisorArn = hypervisorArn;
        }

        @Override
        public final Builder hypervisorArn(String hypervisorArn) {
            this.hypervisorArn = hypervisorArn;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final List<VmwareToAwsTagMapping.Builder> getVmwareToAwsTagMappings() {
            List<VmwareToAwsTagMapping.Builder> result = VmwareToAwsTagMappingsCopier.copyToBuilder(this.vmwareToAwsTagMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVmwareToAwsTagMappings(Collection<VmwareToAwsTagMapping.BuilderImpl> vmwareToAwsTagMappings) {
            this.vmwareToAwsTagMappings = VmwareToAwsTagMappingsCopier.copyFromBuilder(vmwareToAwsTagMappings);
        }

        @Override
        public final Builder vmwareToAwsTagMappings(Collection<VmwareToAwsTagMapping> vmwareToAwsTagMappings) {
            this.vmwareToAwsTagMappings = VmwareToAwsTagMappingsCopier.copy(vmwareToAwsTagMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vmwareToAwsTagMappings(VmwareToAwsTagMapping ... vmwareToAwsTagMappings) {
            this.vmwareToAwsTagMappings(Arrays.asList(vmwareToAwsTagMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vmwareToAwsTagMappings(Consumer<VmwareToAwsTagMapping.Builder> ... vmwareToAwsTagMappings) {
            this.vmwareToAwsTagMappings(Stream.of(vmwareToAwsTagMappings).map(c -> (VmwareToAwsTagMapping)((VmwareToAwsTagMapping.Builder)VmwareToAwsTagMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetHypervisorPropertyMappingsResponse build() {
            return new GetHypervisorPropertyMappingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetHypervisorPropertyMappingsResponse> {
        public Builder hypervisorArn(String var1);

        public Builder iamRoleArn(String var1);

        public Builder vmwareToAwsTagMappings(Collection<VmwareToAwsTagMapping> var1);

        public Builder vmwareToAwsTagMappings(VmwareToAwsTagMapping ... var1);

        public Builder vmwareToAwsTagMappings(Consumer<VmwareToAwsTagMapping.Builder> ... var1);
    }
}

