/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupgateway.model.BackupGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateHypervisorRequest
extends BackupGatewayRequest
implements ToCopyableBuilder<Builder, UpdateHypervisorRequest> {
    private static final SdkField<String> HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Host").getter(UpdateHypervisorRequest.getter(UpdateHypervisorRequest::host)).setter(UpdateHypervisorRequest.setter(Builder::host)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()}).build();
    private static final SdkField<String> HYPERVISOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HypervisorArn").getter(UpdateHypervisorRequest.getter(UpdateHypervisorRequest::hypervisorArn)).setter(UpdateHypervisorRequest.setter(Builder::hypervisorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HypervisorArn").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Password").getter(UpdateHypervisorRequest.getter(UpdateHypervisorRequest::password)).setter(UpdateHypervisorRequest.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(UpdateHypervisorRequest.getter(UpdateHypervisorRequest::username)).setter(UpdateHypervisorRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD, HYPERVISOR_ARN_FIELD, PASSWORD_FIELD, USERNAME_FIELD));
    private final String host;
    private final String hypervisorArn;
    private final String password;
    private final String username;

    private UpdateHypervisorRequest(BuilderImpl builder) {
        super(builder);
        this.host = builder.host;
        this.hypervisorArn = builder.hypervisorArn;
        this.password = builder.password;
        this.username = builder.username;
    }

    public final String host() {
        return this.host;
    }

    public final String hypervisorArn() {
        return this.hypervisorArn;
    }

    public final String password() {
        return this.password;
    }

    public final String username() {
        return this.username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.host());
        hashCode = 31 * hashCode + Objects.hashCode(this.hypervisorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHypervisorRequest)) {
            return false;
        }
        UpdateHypervisorRequest other = (UpdateHypervisorRequest)((Object)obj);
        return Objects.equals(this.host(), other.host()) && Objects.equals(this.hypervisorArn(), other.hypervisorArn()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.username(), other.username());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateHypervisorRequest").add("Host", (Object)this.host()).add("HypervisorArn", (Object)this.hypervisorArn()).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).add("Username", (Object)(this.username() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Host": {
                return Optional.ofNullable(clazz.cast(this.host()));
            }
            case "HypervisorArn": {
                return Optional.ofNullable(clazz.cast(this.hypervisorArn()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateHypervisorRequest, T> g) {
        return obj -> g.apply((UpdateHypervisorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupGatewayRequest.BuilderImpl
    implements Builder {
        private String host;
        private String hypervisorArn;
        private String password;
        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHypervisorRequest model) {
            super(model);
            this.host(model.host);
            this.hypervisorArn(model.hypervisorArn);
            this.password(model.password);
            this.username(model.username);
        }

        public final String getHost() {
            return this.host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        @Transient
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final String getHypervisorArn() {
            return this.hypervisorArn;
        }

        public final void setHypervisorArn(String hypervisorArn) {
            this.hypervisorArn = hypervisorArn;
        }

        @Override
        @Transient
        public final Builder hypervisorArn(String hypervisorArn) {
            this.hypervisorArn = hypervisorArn;
            return this;
        }

        public final String getPassword() {
            return this.password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        @Transient
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        @Transient
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateHypervisorRequest build() {
            return new UpdateHypervisorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateHypervisorRequest> {
        public Builder host(String var1);

        public Builder hypervisorArn(String var1);

        public Builder password(String var1);

        public Builder username(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

