/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.MalwareScanner;
import software.amazon.awssdk.services.backup.model.ResourceTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScanSetting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScanSetting> {
    private static final SdkField<String> MALWARE_SCANNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MalwareScanner").getter(ScanSetting.getter(ScanSetting::malwareScannerAsString)).setter(ScanSetting.setter(Builder::malwareScanner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MalwareScanner").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypes").getter(ScanSetting.getter(ScanSetting::resourceTypes)).setter(ScanSetting.setter(Builder::resourceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCANNER_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScannerRoleArn").getter(ScanSetting.getter(ScanSetting::scannerRoleArn)).setter(ScanSetting.setter(Builder::scannerRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScannerRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MALWARE_SCANNER_FIELD, RESOURCE_TYPES_FIELD, SCANNER_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScanSetting.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String malwareScanner;
    private final List<String> resourceTypes;
    private final String scannerRoleArn;

    private ScanSetting(BuilderImpl builder) {
        this.malwareScanner = builder.malwareScanner;
        this.resourceTypes = builder.resourceTypes;
        this.scannerRoleArn = builder.scannerRoleArn;
    }

    public final MalwareScanner malwareScanner() {
        return MalwareScanner.fromValue(this.malwareScanner);
    }

    public final String malwareScannerAsString() {
        return this.malwareScanner;
    }

    public final boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypes() {
        return this.resourceTypes;
    }

    public final String scannerRoleArn() {
        return this.scannerRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.malwareScannerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypes() ? this.resourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scannerRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanSetting)) {
            return false;
        }
        ScanSetting other = (ScanSetting)obj;
        return Objects.equals(this.malwareScannerAsString(), other.malwareScannerAsString()) && this.hasResourceTypes() == other.hasResourceTypes() && Objects.equals(this.resourceTypes(), other.resourceTypes()) && Objects.equals(this.scannerRoleArn(), other.scannerRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"ScanSetting").add("MalwareScanner", (Object)this.malwareScannerAsString()).add("ResourceTypes", this.hasResourceTypes() ? this.resourceTypes() : null).add("ScannerRoleArn", (Object)this.scannerRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MalwareScanner": {
                return Optional.ofNullable(clazz.cast(this.malwareScannerAsString()));
            }
            case "ResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypes()));
            }
            case "ScannerRoleArn": {
                return Optional.ofNullable(clazz.cast(this.scannerRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MalwareScanner", MALWARE_SCANNER_FIELD);
        map.put("ResourceTypes", RESOURCE_TYPES_FIELD);
        map.put("ScannerRoleArn", SCANNER_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScanSetting, T> g) {
        return obj -> g.apply((ScanSetting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String malwareScanner;
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();
        private String scannerRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanSetting model) {
            this.malwareScanner(model.malwareScanner);
            this.resourceTypes(model.resourceTypes);
            this.scannerRoleArn(model.scannerRoleArn);
        }

        public final String getMalwareScanner() {
            return this.malwareScanner;
        }

        public final void setMalwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
        }

        @Override
        public final Builder malwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
            return this;
        }

        @Override
        public final Builder malwareScanner(MalwareScanner malwareScanner) {
            this.malwareScanner(malwareScanner == null ? null : malwareScanner.toString());
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (this.resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final String getScannerRoleArn() {
            return this.scannerRoleArn;
        }

        public final void setScannerRoleArn(String scannerRoleArn) {
            this.scannerRoleArn = scannerRoleArn;
        }

        @Override
        public final Builder scannerRoleArn(String scannerRoleArn) {
            this.scannerRoleArn = scannerRoleArn;
            return this;
        }

        public ScanSetting build() {
            return new ScanSetting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScanSetting> {
        public Builder malwareScanner(String var1);

        public Builder malwareScanner(MalwareScanner var1);

        public Builder resourceTypes(Collection<String> var1);

        public Builder resourceTypes(String ... var1);

        public Builder scannerRoleArn(String var1);
    }
}

