/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScanJobState {
    COMPLETED("COMPLETED"),
    COMPLETED_WITH_ISSUES("COMPLETED_WITH_ISSUES"),
    FAILED("FAILED"),
    CANCELED("CANCELED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScanJobState> VALUE_MAP;
    private final String value;

    private ScanJobState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScanJobState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScanJobState> knownValues() {
        EnumSet<ScanJobState> knownValues = EnumSet.allOf(ScanJobState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScanJobState.class, ScanJobState::toString);
    }
}

