/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.MalwareScanner;
import software.amazon.awssdk.services.backup.model.ScanMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScanAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScanAction> {
    private static final SdkField<String> MALWARE_SCANNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MalwareScanner").getter(ScanAction.getter(ScanAction::malwareScannerAsString)).setter(ScanAction.setter(Builder::malwareScanner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MalwareScanner").build()}).build();
    private static final SdkField<String> SCAN_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanMode").getter(ScanAction.getter(ScanAction::scanModeAsString)).setter(ScanAction.setter(Builder::scanMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MALWARE_SCANNER_FIELD, SCAN_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScanAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String malwareScanner;
    private final String scanMode;

    private ScanAction(BuilderImpl builder) {
        this.malwareScanner = builder.malwareScanner;
        this.scanMode = builder.scanMode;
    }

    public final MalwareScanner malwareScanner() {
        return MalwareScanner.fromValue(this.malwareScanner);
    }

    public final String malwareScannerAsString() {
        return this.malwareScanner;
    }

    public final ScanMode scanMode() {
        return ScanMode.fromValue(this.scanMode);
    }

    public final String scanModeAsString() {
        return this.scanMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.malwareScannerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanAction)) {
            return false;
        }
        ScanAction other = (ScanAction)obj;
        return Objects.equals(this.malwareScannerAsString(), other.malwareScannerAsString()) && Objects.equals(this.scanModeAsString(), other.scanModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ScanAction").add("MalwareScanner", (Object)this.malwareScannerAsString()).add("ScanMode", (Object)this.scanModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MalwareScanner": {
                return Optional.ofNullable(clazz.cast(this.malwareScannerAsString()));
            }
            case "ScanMode": {
                return Optional.ofNullable(clazz.cast(this.scanModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("MalwareScanner", MALWARE_SCANNER_FIELD);
        map.put("ScanMode", SCAN_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScanAction, T> g) {
        return obj -> g.apply((ScanAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String malwareScanner;
        private String scanMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanAction model) {
            this.malwareScanner(model.malwareScanner);
            this.scanMode(model.scanMode);
        }

        public final String getMalwareScanner() {
            return this.malwareScanner;
        }

        public final void setMalwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
        }

        @Override
        public final Builder malwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
            return this;
        }

        @Override
        public final Builder malwareScanner(MalwareScanner malwareScanner) {
            this.malwareScanner(malwareScanner == null ? null : malwareScanner.toString());
            return this;
        }

        public final String getScanMode() {
            return this.scanMode;
        }

        public final void setScanMode(String scanMode) {
            this.scanMode = scanMode;
        }

        @Override
        public final Builder scanMode(String scanMode) {
            this.scanMode = scanMode;
            return this;
        }

        @Override
        public final Builder scanMode(ScanMode scanMode) {
            this.scanMode(scanMode == null ? null : scanMode.toString());
            return this;
        }

        public ScanAction build() {
            return new ScanAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScanAction> {
        public Builder malwareScanner(String var1);

        public Builder malwareScanner(MalwareScanner var1);

        public Builder scanMode(String var1);

        public Builder scanMode(ScanMode var1);
    }
}

