/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartScanJobRequest extends BackupRequest implements
        ToCopyableBuilder<StartScanJobRequest.Builder, StartScanJobRequest> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultName").getter(getter(StartScanJobRequest::backupVaultName))
            .setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(StartScanJobRequest::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdempotencyToken").getter(getter(StartScanJobRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()).build();

    private static final SdkField<String> MALWARE_SCANNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MalwareScanner").getter(getter(StartScanJobRequest::malwareScannerAsString))
            .setter(setter(Builder::malwareScanner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MalwareScanner").build()).build();

    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecoveryPointArn").getter(getter(StartScanJobRequest::recoveryPointArn))
            .setter(setter(Builder::recoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()).build();

    private static final SdkField<String> SCAN_BASE_RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScanBaseRecoveryPointArn").getter(getter(StartScanJobRequest::scanBaseRecoveryPointArn))
            .setter(setter(Builder::scanBaseRecoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanBaseRecoveryPointArn").build())
            .build();

    private static final SdkField<String> SCAN_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScanMode").getter(getter(StartScanJobRequest::scanModeAsString)).setter(setter(Builder::scanMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanMode").build()).build();

    private static final SdkField<String> SCANNER_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScannerRoleArn").getter(getter(StartScanJobRequest::scannerRoleArn))
            .setter(setter(Builder::scannerRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScannerRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD,
            IAM_ROLE_ARN_FIELD, IDEMPOTENCY_TOKEN_FIELD, MALWARE_SCANNER_FIELD, RECOVERY_POINT_ARN_FIELD,
            SCAN_BASE_RECOVERY_POINT_ARN_FIELD, SCAN_MODE_FIELD, SCANNER_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String backupVaultName;

    private final String iamRoleArn;

    private final String idempotencyToken;

    private final String malwareScanner;

    private final String recoveryPointArn;

    private final String scanBaseRecoveryPointArn;

    private final String scanMode;

    private final String scannerRoleArn;

    private StartScanJobRequest(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.iamRoleArn = builder.iamRoleArn;
        this.idempotencyToken = builder.idempotencyToken;
        this.malwareScanner = builder.malwareScanner;
        this.recoveryPointArn = builder.recoveryPointArn;
        this.scanBaseRecoveryPointArn = builder.scanBaseRecoveryPointArn;
        this.scanMode = builder.scanMode;
        this.scannerRoleArn = builder.scannerRoleArn;
    }

    /**
     * <p>
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique
     * to the account used to create them and the Amazon Web Services Region where they are created.
     * </p>
     * <p>
     * Pattern: <code>^[a-zA-Z0-9\-\_]{2,50}$</code>
     * </p>
     * 
     * @return The name of a logical container where backups are stored. Backup vaults are identified by names that are
     *         unique to the account used to create them and the Amazon Web Services Region where they are created.</p>
     *         <p>
     *         Pattern: <code>^[a-zA-Z0-9\-\_]{2,50}$</code>
     */
    public final String backupVaultName() {
        return backupVaultName;
    }

    /**
     * <p>
     * Specifies the IAM role ARN used to create the target recovery point; for example,
     * <code>arn:aws:iam::123456789012:role/S3Access</code>.
     * </p>
     * 
     * @return Specifies the IAM role ARN used to create the target recovery point; for example,
     *         <code>arn:aws:iam::123456789012:role/S3Access</code>.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * A customer-chosen string that you can use to distinguish between otherwise identical calls to
     * <code>StartScanJob</code>. Retrying a successful request with the same idempotency token results in a success
     * message with no action taken.
     * </p>
     * 
     * @return A customer-chosen string that you can use to distinguish between otherwise identical calls to
     *         <code>StartScanJob</code>. Retrying a successful request with the same idempotency token results in a
     *         success message with no action taken.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    /**
     * <p>
     * Specifies the malware scanner used during the scan job. Currently only supports <code>GUARDDUTY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #malwareScanner}
     * will return {@link MalwareScanner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #malwareScannerAsString}.
     * </p>
     * 
     * @return Specifies the malware scanner used during the scan job. Currently only supports <code>GUARDDUTY</code>.
     * @see MalwareScanner
     */
    public final MalwareScanner malwareScanner() {
        return MalwareScanner.fromValue(malwareScanner);
    }

    /**
     * <p>
     * Specifies the malware scanner used during the scan job. Currently only supports <code>GUARDDUTY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #malwareScanner}
     * will return {@link MalwareScanner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #malwareScannerAsString}.
     * </p>
     * 
     * @return Specifies the malware scanner used during the scan job. Currently only supports <code>GUARDDUTY</code>.
     * @see MalwareScanner
     */
    public final String malwareScannerAsString() {
        return malwareScanner;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a recovery point. This is your target recovery point for a
     * full scan. If you are running an incremental scan, this will be your a recovery point which has been created
     * after your base recovery point selection.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a recovery point. This is your target recovery
     *         point for a full scan. If you are running an incremental scan, this will be your a recovery point which
     *         has been created after your base recovery point selection.
     */
    public final String recoveryPointArn() {
        return recoveryPointArn;
    }

    /**
     * <p>
     * An ARN that uniquely identifies the base recovery point to be used for incremental scanning.
     * </p>
     * 
     * @return An ARN that uniquely identifies the base recovery point to be used for incremental scanning.
     */
    public final String scanBaseRecoveryPointArn() {
        return scanBaseRecoveryPointArn;
    }

    /**
     * <p>
     * Specifies the scan type use for the scan job.
     * </p>
     * <p>
     * Includes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FULL_SCAN</code> will scan the entire data lineage within the backup.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INCREMENTAL_SCAN</code> will scan the data difference between the target recovery point and base recovery
     * point ARN.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanMode} will
     * return {@link ScanMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanModeAsString}.
     * </p>
     * 
     * @return Specifies the scan type use for the scan job.</p>
     *         <p>
     *         Includes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FULL_SCAN</code> will scan the entire data lineage within the backup.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INCREMENTAL_SCAN</code> will scan the data difference between the target recovery point and base
     *         recovery point ARN.
     *         </p>
     *         </li>
     * @see ScanMode
     */
    public final ScanMode scanMode() {
        return ScanMode.fromValue(scanMode);
    }

    /**
     * <p>
     * Specifies the scan type use for the scan job.
     * </p>
     * <p>
     * Includes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FULL_SCAN</code> will scan the entire data lineage within the backup.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INCREMENTAL_SCAN</code> will scan the data difference between the target recovery point and base recovery
     * point ARN.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanMode} will
     * return {@link ScanMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanModeAsString}.
     * </p>
     * 
     * @return Specifies the scan type use for the scan job.</p>
     *         <p>
     *         Includes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FULL_SCAN</code> will scan the entire data lineage within the backup.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INCREMENTAL_SCAN</code> will scan the data difference between the target recovery point and base
     *         recovery point ARN.
     *         </p>
     *         </li>
     * @see ScanMode
     */
    public final String scanModeAsString() {
        return scanMode;
    }

    /**
     * <p>
     * Specified the IAM scanner role ARN.
     * </p>
     * 
     * @return Specified the IAM scanner role ARN.
     */
    public final String scannerRoleArn() {
        return scannerRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(malwareScannerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(scanBaseRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(scanModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scannerRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartScanJobRequest)) {
            return false;
        }
        StartScanJobRequest other = (StartScanJobRequest) obj;
        return Objects.equals(backupVaultName(), other.backupVaultName()) && Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(idempotencyToken(), other.idempotencyToken())
                && Objects.equals(malwareScannerAsString(), other.malwareScannerAsString())
                && Objects.equals(recoveryPointArn(), other.recoveryPointArn())
                && Objects.equals(scanBaseRecoveryPointArn(), other.scanBaseRecoveryPointArn())
                && Objects.equals(scanModeAsString(), other.scanModeAsString())
                && Objects.equals(scannerRoleArn(), other.scannerRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartScanJobRequest").add("BackupVaultName", backupVaultName()).add("IamRoleArn", iamRoleArn())
                .add("IdempotencyToken", idempotencyToken()).add("MalwareScanner", malwareScannerAsString())
                .add("RecoveryPointArn", recoveryPointArn()).add("ScanBaseRecoveryPointArn", scanBaseRecoveryPointArn())
                .add("ScanMode", scanModeAsString()).add("ScannerRoleArn", scannerRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        case "MalwareScanner":
            return Optional.ofNullable(clazz.cast(malwareScannerAsString()));
        case "RecoveryPointArn":
            return Optional.ofNullable(clazz.cast(recoveryPointArn()));
        case "ScanBaseRecoveryPointArn":
            return Optional.ofNullable(clazz.cast(scanBaseRecoveryPointArn()));
        case "ScanMode":
            return Optional.ofNullable(clazz.cast(scanModeAsString()));
        case "ScannerRoleArn":
            return Optional.ofNullable(clazz.cast(scannerRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BackupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("IdempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
        map.put("MalwareScanner", MALWARE_SCANNER_FIELD);
        map.put("RecoveryPointArn", RECOVERY_POINT_ARN_FIELD);
        map.put("ScanBaseRecoveryPointArn", SCAN_BASE_RECOVERY_POINT_ARN_FIELD);
        map.put("ScanMode", SCAN_MODE_FIELD);
        map.put("ScannerRoleArn", SCANNER_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartScanJobRequest, T> g) {
        return obj -> g.apply((StartScanJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartScanJobRequest> {
        /**
         * <p>
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are
         * unique to the account used to create them and the Amazon Web Services Region where they are created.
         * </p>
         * <p>
         * Pattern: <code>^[a-zA-Z0-9\-\_]{2,50}$</code>
         * </p>
         * 
         * @param backupVaultName
         *        The name of a logical container where backups are stored. Backup vaults are identified by names that
         *        are unique to the account used to create them and the Amazon Web Services Region where they are
         *        created.</p>
         *        <p>
         *        Pattern: <code>^[a-zA-Z0-9\-\_]{2,50}$</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * Specifies the IAM role ARN used to create the target recovery point; for example,
         * <code>arn:aws:iam::123456789012:role/S3Access</code>.
         * </p>
         * 
         * @param iamRoleArn
         *        Specifies the IAM role ARN used to create the target recovery point; for example,
         *        <code>arn:aws:iam::123456789012:role/S3Access</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * A customer-chosen string that you can use to distinguish between otherwise identical calls to
         * <code>StartScanJob</code>. Retrying a successful request with the same idempotency token results in a success
         * message with no action taken.
         * </p>
         * 
         * @param idempotencyToken
         *        A customer-chosen string that you can use to distinguish between otherwise identical calls to
         *        <code>StartScanJob</code>. Retrying a successful request with the same idempotency token results in a
         *        success message with no action taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        /**
         * <p>
         * Specifies the malware scanner used during the scan job. Currently only supports <code>GUARDDUTY</code>.
         * </p>
         * 
         * @param malwareScanner
         *        Specifies the malware scanner used during the scan job. Currently only supports <code>GUARDDUTY</code>
         *        .
         * @see MalwareScanner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MalwareScanner
         */
        Builder malwareScanner(String malwareScanner);

        /**
         * <p>
         * Specifies the malware scanner used during the scan job. Currently only supports <code>GUARDDUTY</code>.
         * </p>
         * 
         * @param malwareScanner
         *        Specifies the malware scanner used during the scan job. Currently only supports <code>GUARDDUTY</code>
         *        .
         * @see MalwareScanner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MalwareScanner
         */
        Builder malwareScanner(MalwareScanner malwareScanner);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a recovery point. This is your target recovery point
         * for a full scan. If you are running an incremental scan, this will be your a recovery point which has been
         * created after your base recovery point selection.
         * </p>
         * 
         * @param recoveryPointArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a recovery point. This is your target recovery
         *        point for a full scan. If you are running an incremental scan, this will be your a recovery point
         *        which has been created after your base recovery point selection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointArn(String recoveryPointArn);

        /**
         * <p>
         * An ARN that uniquely identifies the base recovery point to be used for incremental scanning.
         * </p>
         * 
         * @param scanBaseRecoveryPointArn
         *        An ARN that uniquely identifies the base recovery point to be used for incremental scanning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanBaseRecoveryPointArn(String scanBaseRecoveryPointArn);

        /**
         * <p>
         * Specifies the scan type use for the scan job.
         * </p>
         * <p>
         * Includes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FULL_SCAN</code> will scan the entire data lineage within the backup.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCREMENTAL_SCAN</code> will scan the data difference between the target recovery point and base
         * recovery point ARN.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scanMode
         *        Specifies the scan type use for the scan job.</p>
         *        <p>
         *        Includes:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FULL_SCAN</code> will scan the entire data lineage within the backup.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INCREMENTAL_SCAN</code> will scan the data difference between the target recovery point and base
         *        recovery point ARN.
         *        </p>
         *        </li>
         * @see ScanMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanMode
         */
        Builder scanMode(String scanMode);

        /**
         * <p>
         * Specifies the scan type use for the scan job.
         * </p>
         * <p>
         * Includes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FULL_SCAN</code> will scan the entire data lineage within the backup.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INCREMENTAL_SCAN</code> will scan the data difference between the target recovery point and base
         * recovery point ARN.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scanMode
         *        Specifies the scan type use for the scan job.</p>
         *        <p>
         *        Includes:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FULL_SCAN</code> will scan the entire data lineage within the backup.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INCREMENTAL_SCAN</code> will scan the data difference between the target recovery point and base
         *        recovery point ARN.
         *        </p>
         *        </li>
         * @see ScanMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanMode
         */
        Builder scanMode(ScanMode scanMode);

        /**
         * <p>
         * Specified the IAM scanner role ARN.
         * </p>
         * 
         * @param scannerRoleArn
         *        Specified the IAM scanner role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scannerRoleArn(String scannerRoleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String backupVaultName;

        private String iamRoleArn;

        private String idempotencyToken;

        private String malwareScanner;

        private String recoveryPointArn;

        private String scanBaseRecoveryPointArn;

        private String scanMode;

        private String scannerRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StartScanJobRequest model) {
            super(model);
            backupVaultName(model.backupVaultName);
            iamRoleArn(model.iamRoleArn);
            idempotencyToken(model.idempotencyToken);
            malwareScanner(model.malwareScanner);
            recoveryPointArn(model.recoveryPointArn);
            scanBaseRecoveryPointArn(model.scanBaseRecoveryPointArn);
            scanMode(model.scanMode);
            scannerRoleArn(model.scannerRoleArn);
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final String getMalwareScanner() {
            return malwareScanner;
        }

        public final void setMalwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
        }

        @Override
        public final Builder malwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
            return this;
        }

        @Override
        public final Builder malwareScanner(MalwareScanner malwareScanner) {
            this.malwareScanner(malwareScanner == null ? null : malwareScanner.toString());
            return this;
        }

        public final String getRecoveryPointArn() {
            return recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final String getScanBaseRecoveryPointArn() {
            return scanBaseRecoveryPointArn;
        }

        public final void setScanBaseRecoveryPointArn(String scanBaseRecoveryPointArn) {
            this.scanBaseRecoveryPointArn = scanBaseRecoveryPointArn;
        }

        @Override
        public final Builder scanBaseRecoveryPointArn(String scanBaseRecoveryPointArn) {
            this.scanBaseRecoveryPointArn = scanBaseRecoveryPointArn;
            return this;
        }

        public final String getScanMode() {
            return scanMode;
        }

        public final void setScanMode(String scanMode) {
            this.scanMode = scanMode;
        }

        @Override
        public final Builder scanMode(String scanMode) {
            this.scanMode = scanMode;
            return this;
        }

        @Override
        public final Builder scanMode(ScanMode scanMode) {
            this.scanMode(scanMode == null ? null : scanMode.toString());
            return this;
        }

        public final String getScannerRoleArn() {
            return scannerRoleArn;
        }

        public final void setScannerRoleArn(String scannerRoleArn) {
            this.scannerRoleArn = scannerRoleArn;
        }

        @Override
        public final Builder scannerRoleArn(String scannerRoleArn) {
            this.scannerRoleArn = scannerRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartScanJobRequest build() {
            return new StartScanJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
