/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTieringConfigurationResponse extends BackupResponse implements
        ToCopyableBuilder<CreateTieringConfigurationResponse.Builder, CreateTieringConfigurationResponse> {
    private static final SdkField<String> TIERING_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TieringConfigurationArn").getter(getter(CreateTieringConfigurationResponse::tieringConfigurationArn))
            .setter(setter(Builder::tieringConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringConfigurationArn").build())
            .build();

    private static final SdkField<String> TIERING_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TieringConfigurationName").getter(getter(CreateTieringConfigurationResponse::tieringConfigurationName))
            .setter(setter(Builder::tieringConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringConfigurationName").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(CreateTieringConfigurationResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TIERING_CONFIGURATION_ARN_FIELD, TIERING_CONFIGURATION_NAME_FIELD, CREATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String tieringConfigurationArn;

    private final String tieringConfigurationName;

    private final Instant creationTime;

    private CreateTieringConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.tieringConfigurationArn = builder.tieringConfigurationArn;
        this.tieringConfigurationName = builder.tieringConfigurationName;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies the created tiering configuration.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies the created tiering configuration.
     */
    public final String tieringConfigurationArn() {
        return tieringConfigurationArn;
    }

    /**
     * <p>
     * This unique string is the name of the tiering configuration.
     * </p>
     * <p>
     * The name cannot be changed after creation. The name consists of only alphanumeric characters and underscores.
     * Maximum length is 200.
     * </p>
     * 
     * @return This unique string is the name of the tiering configuration.</p>
     *         <p>
     *         The name cannot be changed after creation. The name consists of only alphanumeric characters and
     *         underscores. Maximum length is 200.
     */
    public final String tieringConfigurationName() {
        return tieringConfigurationName;
    }

    /**
     * <p>
     * The date and time a tiering configuration was created, in Unix format and Coordinated Universal Time (UTC). The
     * value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
     * Friday, January 26, 2018 12:11:30.087AM.
     * </p>
     * 
     * @return The date and time a tiering configuration was created, in Unix format and Coordinated Universal Time
     *         (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value
     *         1516925490.087 represents Friday, January 26, 2018 12:11:30.087AM.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tieringConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(tieringConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTieringConfigurationResponse)) {
            return false;
        }
        CreateTieringConfigurationResponse other = (CreateTieringConfigurationResponse) obj;
        return Objects.equals(tieringConfigurationArn(), other.tieringConfigurationArn())
                && Objects.equals(tieringConfigurationName(), other.tieringConfigurationName())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTieringConfigurationResponse").add("TieringConfigurationArn", tieringConfigurationArn())
                .add("TieringConfigurationName", tieringConfigurationName()).add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TieringConfigurationArn":
            return Optional.ofNullable(clazz.cast(tieringConfigurationArn()));
        case "TieringConfigurationName":
            return Optional.ofNullable(clazz.cast(tieringConfigurationName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TieringConfigurationArn", TIERING_CONFIGURATION_ARN_FIELD);
        map.put("TieringConfigurationName", TIERING_CONFIGURATION_NAME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTieringConfigurationResponse, T> g) {
        return obj -> g.apply((CreateTieringConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTieringConfigurationResponse> {
        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies the created tiering configuration.
         * </p>
         * 
         * @param tieringConfigurationArn
         *        An Amazon Resource Name (ARN) that uniquely identifies the created tiering configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tieringConfigurationArn(String tieringConfigurationArn);

        /**
         * <p>
         * This unique string is the name of the tiering configuration.
         * </p>
         * <p>
         * The name cannot be changed after creation. The name consists of only alphanumeric characters and underscores.
         * Maximum length is 200.
         * </p>
         * 
         * @param tieringConfigurationName
         *        This unique string is the name of the tiering configuration.</p>
         *        <p>
         *        The name cannot be changed after creation. The name consists of only alphanumeric characters and
         *        underscores. Maximum length is 200.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tieringConfigurationName(String tieringConfigurationName);

        /**
         * <p>
         * The date and time a tiering configuration was created, in Unix format and Coordinated Universal Time (UTC).
         * The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087
         * represents Friday, January 26, 2018 12:11:30.087AM.
         * </p>
         * 
         * @param creationTime
         *        The date and time a tiering configuration was created, in Unix format and Coordinated Universal Time
         *        (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String tieringConfigurationArn;

        private String tieringConfigurationName;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTieringConfigurationResponse model) {
            super(model);
            tieringConfigurationArn(model.tieringConfigurationArn);
            tieringConfigurationName(model.tieringConfigurationName);
            creationTime(model.creationTime);
        }

        public final String getTieringConfigurationArn() {
            return tieringConfigurationArn;
        }

        public final void setTieringConfigurationArn(String tieringConfigurationArn) {
            this.tieringConfigurationArn = tieringConfigurationArn;
        }

        @Override
        public final Builder tieringConfigurationArn(String tieringConfigurationArn) {
            this.tieringConfigurationArn = tieringConfigurationArn;
            return this;
        }

        public final String getTieringConfigurationName() {
            return tieringConfigurationName;
        }

        public final void setTieringConfigurationName(String tieringConfigurationName) {
            this.tieringConfigurationName = tieringConfigurationName;
        }

        @Override
        public final Builder tieringConfigurationName(String tieringConfigurationName) {
            this.tieringConfigurationName = tieringConfigurationName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public CreateTieringConfigurationResponse build() {
            return new CreateTieringConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
