/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateReportPlanResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, UpdateReportPlanResponse> {
    private static final SdkField<String> REPORT_PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportPlanName").getter(UpdateReportPlanResponse.getter(UpdateReportPlanResponse::reportPlanName)).setter(UpdateReportPlanResponse.setter(Builder::reportPlanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportPlanName").build()}).build();
    private static final SdkField<String> REPORT_PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportPlanArn").getter(UpdateReportPlanResponse.getter(UpdateReportPlanResponse::reportPlanArn)).setter(UpdateReportPlanResponse.setter(Builder::reportPlanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportPlanArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(UpdateReportPlanResponse.getter(UpdateReportPlanResponse::creationTime)).setter(UpdateReportPlanResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_PLAN_NAME_FIELD, REPORT_PLAN_ARN_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateReportPlanResponse.memberNameToFieldInitializer();
    private final String reportPlanName;
    private final String reportPlanArn;
    private final Instant creationTime;

    private UpdateReportPlanResponse(BuilderImpl builder) {
        super(builder);
        this.reportPlanName = builder.reportPlanName;
        this.reportPlanArn = builder.reportPlanArn;
        this.creationTime = builder.creationTime;
    }

    public final String reportPlanName() {
        return this.reportPlanName;
    }

    public final String reportPlanArn() {
        return this.reportPlanArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reportPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReportPlanResponse)) {
            return false;
        }
        UpdateReportPlanResponse other = (UpdateReportPlanResponse)((Object)obj);
        return Objects.equals(this.reportPlanName(), other.reportPlanName()) && Objects.equals(this.reportPlanArn(), other.reportPlanArn()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateReportPlanResponse").add("ReportPlanName", (Object)this.reportPlanName()).add("ReportPlanArn", (Object)this.reportPlanArn()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportPlanName": {
                return Optional.ofNullable(clazz.cast(this.reportPlanName()));
            }
            case "ReportPlanArn": {
                return Optional.ofNullable(clazz.cast(this.reportPlanArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReportPlanName", REPORT_PLAN_NAME_FIELD);
        map.put("ReportPlanArn", REPORT_PLAN_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateReportPlanResponse, T> g) {
        return obj -> g.apply((UpdateReportPlanResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String reportPlanName;
        private String reportPlanArn;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReportPlanResponse model) {
            super(model);
            this.reportPlanName(model.reportPlanName);
            this.reportPlanArn(model.reportPlanArn);
            this.creationTime(model.creationTime);
        }

        public final String getReportPlanName() {
            return this.reportPlanName;
        }

        public final void setReportPlanName(String reportPlanName) {
            this.reportPlanName = reportPlanName;
        }

        @Override
        public final Builder reportPlanName(String reportPlanName) {
            this.reportPlanName = reportPlanName;
            return this;
        }

        public final String getReportPlanArn() {
            return this.reportPlanArn;
        }

        public final void setReportPlanArn(String reportPlanArn) {
            this.reportPlanArn = reportPlanArn;
        }

        @Override
        public final Builder reportPlanArn(String reportPlanArn) {
            this.reportPlanArn = reportPlanArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public UpdateReportPlanResponse build() {
            return new UpdateReportPlanResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateReportPlanResponse> {
        public Builder reportPlanName(String var1);

        public Builder reportPlanArn(String var1);

        public Builder creationTime(Instant var1);
    }
}

